/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.transform.executor;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class TransformedJarHelper {
    private static final Map<String, String> TRANSFORMED_PLUGIN_CACHE_DIRS = ImmutableMap.builder().put((Object)"confluence", (Object)"/plugins-osgi-cache/transformed-plugins").put((Object)"crowd", (Object)"/caches/transformed-plugins").put((Object)"jira", (Object)"/plugins/.osgi-plugins/transformed-plugins").put((Object)"bamboo", (Object)"/caches/plugins/transformed-plugins").put((Object)"bitbucket", (Object)"/plugins/.osgi-cache/transformed-plugins").put((Object)"refapp", (Object)"/osgi-cache/transformed-plugins").build();
    private final String productId;
    private final MavenContext context;

    public TransformedJarHelper(String productId, MavenContext context) {
        this.productId = Objects.requireNonNull(productId);
        this.context = Objects.requireNonNull(context);
    }

    public File findMostRecentTransformedJar() throws MojoExecutionException {
        return this.findMostRecentTransformedJar(this.context.getProject().getBuild().getFinalName());
    }

    public File findMostRecentTransformedTestJar() throws MojoExecutionException {
        return this.findMostRecentTransformedJar(this.context.getProject().getBuild().getFinalName() + "-tests");
    }

    public File findMostRecentTransformedJar(String builtFilenameWithoutExtension) throws MojoExecutionException {
        String regex = Pattern.quote(builtFilenameWithoutExtension) + "_(\\d+)\\.jar";
        return this.findMostRecentTransformedJar(Pattern.compile(regex));
    }

    private File findMostRecentTransformedJar(Pattern pattern) throws MojoExecutionException {
        return Arrays.stream((Object[])Objects.requireNonNull(this.getTransformedDirectory().listFiles())).map(file -> {
            Matcher matcher = pattern.matcher(file.getName());
            if (matcher.matches()) {
                long timestamp = Long.parseLong(matcher.group(1));
                return new FileWithTimestamp((File)file, timestamp);
            }
            return null;
        }).filter(Objects::nonNull).max(Comparator.comparingLong(fwt -> fwt.timestamp)).map(fwt -> fwt.file).orElseThrow(() -> new MojoExecutionException("Cached transformed plugin JAR does not exist. Please execute a 'run' or 'debug' goal first."));
    }

    private File getTransformedDirectory() throws MojoExecutionException {
        String cacheDir = TRANSFORMED_PLUGIN_CACHE_DIRS.get(this.productId);
        if (cacheDir == null) {
            throw new MojoExecutionException("Unsupported product ID: " + this.productId);
        }
        File baseDirectory = new File(this.context.getBuildDirectory(), this.productId);
        File homeDirectory = new File(baseDirectory, "home");
        File transformedDirectory = new File(homeDirectory, cacheDir);
        if (!transformedDirectory.exists()) {
            throw new MojoExecutionException(StringUtils.capitalize((String)this.productId) + " transformed plugin cache directory does not exist: " + transformedDirectory.getAbsolutePath() + ". Please execute a 'run' or 'debug' goal first.");
        }
        return transformedDirectory;
    }

    public void verifyTransformedJarMatchesProject(File transformedJar) throws MojoExecutionException {
        Properties props = this.getProperties(transformedJar);
        String expectedGroupId = this.context.getProject().getGroupId();
        String expectedArtifactId = this.context.getProject().getArtifactId();
        String actualGroupId = props.getProperty("groupId");
        String actualArtifactId = props.getProperty("artifactId");
        if (!expectedGroupId.equals(actualGroupId) || !expectedArtifactId.equals(actualArtifactId)) {
            throw new MojoExecutionException("Transformed JAR does not match current project. Expected: " + expectedGroupId + ":" + expectedArtifactId + ", but found: " + actualGroupId + ":" + actualArtifactId);
        }
    }

    private Properties getProperties(File transformedJar) throws MojoExecutionException {
        String pomPropertiesPath = "META-INF/maven/" + this.context.getProject().getGroupId() + "/" + this.context.getProject().getArtifactId() + "/pom.properties";
        Properties props = new Properties();
        try (ZipFile zipFile = new ZipFile(transformedJar);){
            ZipEntry entry = zipFile.getEntry(pomPropertiesPath);
            if (entry == null) {
                throw new MojoExecutionException("Could not find " + pomPropertiesPath + " in transformed JAR: " + transformedJar.getAbsolutePath());
            }
            try (InputStream is = zipFile.getInputStream(entry);){
                props.load(is);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read " + pomPropertiesPath + " from transformed JAR: " + transformedJar.getAbsolutePath(), (Exception)e);
        }
        return props;
    }

    private static class FileWithTimestamp {
        final File file;
        final long timestamp;

        FileWithTimestamp(File file, long timestamp) {
            this.file = file;
            this.timestamp = timestamp;
        }
    }
}

