/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.transform.executor;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.osgi.AtlassianPluginContentValidator;
import com.atlassian.maven.plugins.amps.product.common.XMLDocumentHandler;
import com.atlassian.maven.plugins.amps.transform.TransformConfig;
import com.atlassian.maven.plugins.amps.transform.executor.JarExtractionService;
import com.atlassian.maven.plugins.amps.transform.executor.TransformedJarHelper;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.JavaSourcePathUtil;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.SpringXmlToJavaConverter;
import com.atlassian.maven.plugins.amps.util.PluginXmlUtils;
import com.atlassian.maven.plugins.amps.util.manifest.ManifestUtils;
import com.atlassian.plugins.codegen.BundleInstruction;
import com.atlassian.plugins.codegen.ManifestHeader;
import com.atlassian.plugins.codegen.MavenProjectRewriter;
import com.atlassian.plugins.codegen.PluginProjectChange;
import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.PluginXmlRewriter;
import com.atlassian.plugins.codegen.ProjectPackaging;
import com.atlassian.plugins.codegen.RemovePluginDescriptorElements;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;

public class TransformExecutor {
    private final TransformConfig configuration;
    private final String productId;
    private final MavenContext mavenContext;
    private final Log log;
    private final TransformedJarHelper transformedJarHelper;
    private final JarExtractionService jarExtractionService;
    private final SpringXmlToJavaConverter springJavaConverter;
    private PluginProjectChangeset projectChangeset;
    private File transformedJar;

    public TransformExecutor(TransformConfig configuration, String productId, MavenContext mavenContext, Log log) {
        this.configuration = configuration;
        this.productId = productId;
        this.mavenContext = mavenContext;
        this.log = log;
        this.transformedJarHelper = new TransformedJarHelper(productId, mavenContext);
        this.jarExtractionService = new JarExtractionService();
        this.springJavaConverter = new SpringXmlToJavaConverter(log);
        this.projectChangeset = new PluginProjectChangeset();
    }

    public void performTransformation() throws MojoExecutionException {
        this.applyPluginPackagingChanges();
        this.applyManifestHeaderChanges();
        this.applySpringContextChanges();
        this.applyBundleInstructionChanges();
        this.applyProjectChanges();
    }

    private void applyPluginPackagingChanges() {
        this.log.info((CharSequence)"Ensuring project packaging is 'atlassian-plugin' and AMPS 'extensions' are enabled.");
        this.projectChangeset.with(new PluginProjectChange[]{ProjectPackaging.atlassianPluginPackaging()});
    }

    private void applyManifestHeaderChanges() throws MojoExecutionException {
        String pluginKey = PluginXmlUtils.extractPluginKey(this.configuration.getPluginDescriptorFile(this.mavenContext));
        this.log.info((CharSequence)("Setting 'Atlassian-Plugin-Key' instruction to '" + pluginKey + "' to signify " + this.configuration.getPluginTypeLabel() + " is transformerless."));
        this.projectChangeset.with(new PluginProjectChange[]{ManifestHeader.manifestHeader((String)"Atlassian-Plugin-Key", (String)pluginKey, (int)0)});
    }

    private void applySpringContextChanges() throws MojoExecutionException {
        this.log.info((CharSequence)("Copying Spring context files from transformed JAR and removing corresponding " + this.configuration.getPluginTypeLabel() + " descriptor elements."));
        Path resourcesPath = this.mavenContext.getProject().getBasedir().toPath().resolve(this.configuration.getResourcesDir());
        try {
            if (!JavaSourcePathUtil.isDirectoryEmpty(resourcesPath.resolve("META-INF/spring"))) {
                this.log.info((CharSequence)"Warning: Existing Spring context files detected in project resources, conversion result may not succeed, or require further manual adjustments.");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        this.jarExtractionService.extractSpringContext(this.transformedJar(), resourcesPath);
        this.log.info((CharSequence)("Wrote to: " + resourcesPath.toAbsolutePath() + "/" + "META-INF/spring"));
        if (this.configuration.useSpringJava()) {
            this.log.info((CharSequence)"Converting Spring XML configuration to Spring Java configuration");
            try {
                boolean isConverted = this.springJavaConverter.convert(resourcesPath);
                if (isConverted) {
                    this.springJavaConverter.getRequiredDependencies().forEach(xva$0 -> this.projectChangeset.with(new PluginProjectChange[]{xva$0}));
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException((Throwable)e);
            }
        }
        AtlassianPluginContentValidator.FORBIDDEN_ELEMENTS.forEach(elName -> this.projectChangeset.with(new PluginProjectChange[]{RemovePluginDescriptorElements.removePluginDescElements((String)elName)}));
        this.log.info((CharSequence)("Setting 'Spring-Context' instruction to '*' to guarantee " + this.configuration.getPluginTypeLabel() + " is Spring-powered."));
        this.projectChangeset.with(new PluginProjectChange[]{ManifestHeader.manifestHeader((String)"Spring-Context", (String)"*", (int)1)});
    }

    private void applyBundleInstructionChanges() throws MojoExecutionException {
        Document atlPluginXmlDoc = XMLDocumentHandler.parse(this.configuration.getPluginDescriptorFile(this.mavenContext));
        this.log.info((CharSequence)("Moving any non-package bundle instructions from " + this.configuration.getPluginTypeLabel() + " descriptor to POM instructions."));
        if (this.configuration.getInstructions() == null) {
            this.projectChangeset.with(this.getPomChangesFromPluginDescBundleInstr(atlPluginXmlDoc));
        }
        this.projectChangeset.with(new PluginProjectChange[]{RemovePluginDescriptorElements.removePluginDescElements((String)"plugin-info/bundle-instructions")});
        this.log.info((CharSequence)"Copying package bundle instructions from transformed JAR.");
        List<BundleInstruction> transformedInstr = this.jarExtractionService.extractBundleInstructions(this.transformedJar());
        List<BundleInstruction> preTransformInstr = this.getBundleInstructionsFromPreTransformedJar();
        List<BundleInstruction> finalPackageInstr = ManifestUtils.dropBundleInstructionsForPackages(ManifestUtils.subtractInstructions(transformedInstr, preTransformInstr), (List<String>)ImmutableList.of((Object)"javax.annotation"));
        finalPackageInstr.add(BundleInstruction.importPackageOptional((String)"javax.annotation.*"));
        this.log.info((CharSequence)"Ensuring 'javax.annotation' package is only optionally imported to maximise compatibility.");
        this.projectChangeset.with(finalPackageInstr);
        this.projectChangeset.with(new PluginProjectChange[]{BundleInstruction.importPackageOptional((String)"*")});
    }

    private void applyProjectChanges() throws MojoExecutionException {
        this.transformProjectChanges();
        this.log.info((CharSequence)("Completing rewrite of " + this.configuration.getPluginTypeLabel() + " descriptor and project POM."));
        this.rewritePluginXml();
        this.rewritePom();
        this.logSuccess();
    }

    private void transformProjectChanges() {
        PluginProjectChangeset transformedChangeset = new PluginProjectChangeset();
        for (PluginProjectChange change : this.projectChangeset.getItems()) {
            transformedChangeset.with(new PluginProjectChange[]{this.configuration.transformChange(change)});
        }
        this.projectChangeset = transformedChangeset;
    }

    private File transformedJar() throws MojoExecutionException {
        return this.locateTransformedJar();
    }

    public File locateTransformedJar() throws MojoExecutionException {
        File transformedJar;
        if (this.transformedJar != null) {
            return this.transformedJar;
        }
        if (this.configuration.getTransformedJarPath() != null) {
            transformedJar = this.getParameterSpecifiedTransformedJar();
        } else {
            transformedJar = this.transformedJarHelper.findMostRecentTransformedJar(this.getBuiltFilenameWithoutExtension());
            this.log.info((CharSequence)("Found " + StringUtils.capitalize((String)this.productId) + " transformed JAR: " + transformedJar.getAbsolutePath()));
        }
        this.transformedJarHelper.verifyTransformedJarMatchesProject(transformedJar);
        this.transformedJar = transformedJar;
        return this.transformedJar;
    }

    private File getParameterSpecifiedTransformedJar() throws MojoExecutionException {
        File transformedJar = new File(this.configuration.getTransformedJarPath());
        this.log.info((CharSequence)("Using parameter-specified transformed JAR: " + transformedJar.getAbsolutePath()));
        if (!transformedJar.exists()) {
            throw new MojoExecutionException("Cached transformed " + this.configuration.getPluginTypeLabel() + " JAR does not exist at: " + transformedJar.getAbsolutePath());
        }
        return transformedJar;
    }

    private Iterable<PluginProjectChange> getPomChangesFromPluginDescBundleInstr(Document atlPluginXmlDoc) {
        Element pluginInfo = atlPluginXmlDoc.getRootElement().element("plugin-info");
        if (pluginInfo == null) {
            return Collections.emptyList();
        }
        Element bundleInstructions = pluginInfo.element("bundle-instructions");
        if (bundleInstructions == null) {
            return Collections.emptyList();
        }
        ArrayList<PluginProjectChange> changelist = new ArrayList<PluginProjectChange>();
        bundleInstructions.elements().forEach(bundleInstr -> this.fromBundleInstrElement((Element)bundleInstr).ifPresent(changelist::add));
        return changelist;
    }

    private Optional<ManifestHeader> fromBundleInstrElement(Element bundleInstr) {
        String instrName = bundleInstr.getName();
        if ("Spring-Context".equals(instrName) || BundleInstruction.Category.fromElementName((String)instrName).isPresent()) {
            return Optional.empty();
        }
        String instrValue = bundleInstr.getTextTrim();
        if (instrValue.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ManifestHeader.manifestHeader((String)instrName, (String)instrValue));
    }

    private List<BundleInstruction> getBundleInstructionsFromPreTransformedJar() throws MojoExecutionException {
        if (this.configuration.getInstructions() == null) {
            return Collections.emptyList();
        }
        File builtJar = new File(this.mavenContext.getBuildDirectory(), this.getBuiltFilenameWithoutExtension() + ".jar");
        if (!builtJar.exists()) {
            throw new MojoExecutionException("Built " + this.configuration.getPluginTypeLabel() + " JAR not found at: " + builtJar.getAbsolutePath());
        }
        return this.jarExtractionService.extractBundleInstructions(builtJar);
    }

    private String getBuiltFilenameWithoutExtension() {
        return this.mavenContext.getProject().getBuild().getFinalName() + this.configuration.getBuiltFilenameSuffix();
    }

    private void rewritePluginXml() throws MojoExecutionException {
        File atlPluginXml = this.configuration.getPluginDescriptorFile(this.mavenContext);
        try {
            new PluginXmlRewriter(atlPluginXml).applyChanges(this.projectChangeset);
        }
        catch (Exception e) {
            throw new MojoExecutionException((Throwable)e);
        }
        this.log.info((CharSequence)("Wrote: " + atlPluginXml.getAbsolutePath()));
    }

    private void rewritePom() throws MojoExecutionException {
        File pomFile = this.mavenContext.getProject().getFile();
        try {
            new MavenProjectRewriter(pomFile).applyChanges(this.projectChangeset);
        }
        catch (Exception e) {
            throw new MojoExecutionException((Throwable)e);
        }
        this.log.info((CharSequence)("Wrote: " + pomFile.getAbsolutePath()));
    }

    private void logSuccess() {
        this.logLineBreak();
        this.log.info((CharSequence)"Transformerless conversion complete!");
        this.logLineBreak();
        this.log.info((CharSequence)("Note that some package-instructions and " + (this.configuration.useSpringJava() ? "lazy-import beans" : "host-components") + " generated by transformation may be unused or redundant. You may wish to tidy them up manually."));
        if (!this.configuration.useSpringJava()) {
            this.log.info((CharSequence)"You may also wish to review https://developer.atlassian.com/server/framework/atlassian-sdk/spring-java-config for a more maintainable alternative to the generated Spring XML configuration files.");
        }
    }

    private void logLineBreak() {
        this.log.info((CharSequence)"");
    }
}

