/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.transform;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.plugins.codegen.PluginProjectChange;
import java.io.File;
import java.util.Map;
import java.util.function.Function;

public class TransformConfig {
    private final String pluginTypeLabel;
    private final String resourcesDir;
    private final String builtFilenameSuffix;
    private final Map<String, String> instructions;
    private final String transformedJarPath;
    private final Function<PluginProjectChange, PluginProjectChange> changeTransformer;
    private final boolean useSpringJava;

    private TransformConfig(Builder builder) {
        this.pluginTypeLabel = builder.pluginTypeLabel;
        this.resourcesDir = builder.resourcesDir;
        this.builtFilenameSuffix = builder.builtFilenameSuffix;
        this.instructions = builder.instructions;
        this.transformedJarPath = builder.transformedJarPath;
        this.changeTransformer = builder.changeTransformer;
        this.useSpringJava = builder.useSpringJava;
    }

    public String getPluginTypeLabel() {
        return this.pluginTypeLabel;
    }

    public String getResourcesDir() {
        return this.resourcesDir;
    }

    public File getPluginDescriptorFile(MavenContext mavenContext) {
        return new File(mavenContext.getProject().getBasedir(), this.getResourcesDir() + "/" + "atlassian-plugin.xml");
    }

    public String getBuiltFilenameSuffix() {
        return this.builtFilenameSuffix;
    }

    public Map<String, String> getInstructions() {
        return this.instructions;
    }

    public String getTransformedJarPath() {
        return this.transformedJarPath;
    }

    public boolean useSpringJava() {
        return this.useSpringJava;
    }

    public PluginProjectChange transformChange(PluginProjectChange change) {
        return this.changeTransformer.apply(change);
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private String pluginTypeLabel;
        private String resourcesDir;
        private String builtFilenameSuffix = "";
        private Map<String, String> instructions;
        private String transformedJarPath;
        private Function<PluginProjectChange, PluginProjectChange> changeTransformer = Function.identity();
        private boolean useSpringJava;

        Builder() {
        }

        public Builder pluginTypeLabel(String pluginTypeLabel) {
            this.pluginTypeLabel = pluginTypeLabel;
            return this;
        }

        public Builder resourcesDir(String resourcesDir) {
            this.resourcesDir = resourcesDir;
            return this;
        }

        public Builder builtFilenameSuffix(String builtFilenameSuffix) {
            this.builtFilenameSuffix = builtFilenameSuffix;
            return this;
        }

        public Builder instructions(Map<String, String> instructions) {
            this.instructions = instructions;
            return this;
        }

        public Builder transformedJarPath(String transformedJarPath) {
            this.transformedJarPath = transformedJarPath;
            return this;
        }

        public Builder changeTransformer(Function<PluginProjectChange, PluginProjectChange> changeTransformer) {
            this.changeTransformer = changeTransformer;
            return this;
        }

        public Builder useSpringJava(boolean useSpringJava) {
            this.useSpringJava = useSpringJava;
            return this;
        }

        public TransformConfig build() {
            return new TransformConfig(this);
        }
    }
}

