/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.manager;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.Node;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.XmlOverride;
import com.atlassian.maven.plugins.amps.product.manager.Container;
import com.atlassian.maven.plugins.amps.product.manager.ContainerConfig;
import com.atlassian.maven.plugins.amps.product.manager.Containers;
import com.atlassian.maven.plugins.amps.product.manager.WebAppManager;
import com.atlassian.maven.plugins.amps.util.MojoExecutorWrapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WebAppManagerImpl
extends AbstractLogEnabled
implements WebAppManager {
    @VisibleForTesting
    static final String AJP_PORT_PROPERTY = "cargo.tomcat.ajp.port";
    static final String SERVLET_USER_PROPERTY = "cargo.servlet.users";
    private static final String PROPERTIES = "properties";
    private final MojoExecutorWrapper mojoExecutorWrapper;

    @Inject
    public WebAppManagerImpl(MojoExecutorWrapper mojoExecutorWrapper) {
        this.mojoExecutorWrapper = Objects.requireNonNull(mojoExecutorWrapper);
    }

    @Override
    @Nonnull
    public List<Node> startWebapp(File productWar, List<Map<String, String>> systemProperties, List<ProductArtifact> extraContainerDependencies, List<ProductArtifact> extraProductDeployables, Product product, MavenContext mavenContext) throws MojoExecutionException {
        List<Node> nodes = product.getNodes();
        Container container = this.getContainer(product);
        for (int nodeIndex = 0; nodeIndex < nodes.size(); ++nodeIndex) {
            Node node = nodes.get(nodeIndex);
            ContainerConfig containerConfig = new ContainerConfig(container, product, nodeIndex);
            if (!container.isEmbedded()) {
                this.unpackOrReuse(containerConfig, mavenContext);
            }
            this.getLogger().info(this.getStartingMessage(product, container, node, nodeIndex));
            this.mojoExecutorWrapper.execute(this.cargoPlugin(mavenContext), MojoExecutor.goal("start"), this.getCargoStartConfiguration(productWar, systemProperties.get(nodeIndex), extraContainerDependencies, extraProductDeployables, containerConfig, mavenContext), mavenContext.getExecutionEnvironment());
            Optional<URI> statusUri = product.getStatusUri(nodeIndex);
            if (!statusUri.isPresent()) continue;
            WebAppManagerImpl.waitForOkResponse(statusUri.get());
        }
        return nodes;
    }

    private String getStartingMessage(Product product, Container container, Node node, int nodeIndex) {
        String messageFormat = "Starting instance '%s'%s on the %s container on ports %d (%s), %d (RMI) and %d (AJP)";
        String nodeBit = product.isMultiNode() ? String.format(" (node %d)", nodeIndex) : "";
        return String.format("Starting instance '%s'%s on the %s container on ports %d (%s), %d (RMI) and %d (AJP)", product.getInstanceId(), nodeBit, container.getId(), node.getWebPort(), StringUtils.upperCase((String)product.getProtocol()), node.getRmiPort(), node.getAjpPort());
    }

    private static void waitForOkResponse(URI statusUri) throws MojoExecutionException {
        int totalWaitTimeInMinutes = 3;
        int retryIntervalInSeconds = 5;
        long maxRetries = TimeUnit.MINUTES.toSeconds(3L) / 5L;
        for (long i = 0L; i < maxRetries; ++i) {
            if (WebAppManagerImpl.getStatusCode(statusUri) == 200) {
                return;
            }
            WebAppManagerImpl.waitForSeconds(5);
        }
        throw new MojoExecutionException(String.format("%s did not return 200 OK after %d attempts", statusUri, maxRetries));
    }

    private static int getStatusCode(URI statusUri) throws MojoExecutionException {
        try {
            URL url = statusUri.toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            return connection.getResponseCode();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not get status code from " + statusUri, (Exception)e);
        }
    }

    private static void waitForSeconds(int seconds) {
        long waitTimeMillis = TimeUnit.SECONDS.toMillis(seconds);
        try {
            Thread.sleep(waitTimeMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Nullable
    private MojoExecutor.Element xmlReplacementsElement(Collection<XmlOverride> cargoXmlOverrides) {
        if (cargoXmlOverrides == null) {
            return null;
        }
        MojoExecutor.Element[] xmlReplacementsElements = (MojoExecutor.Element[])cargoXmlOverrides.stream().map(xmlOverride -> MojoExecutor.element(MojoExecutor.name("xmlReplacement"), MojoExecutor.element(MojoExecutor.name("file"), xmlOverride.getFile()), MojoExecutor.element(MojoExecutor.name("xpathExpression"), xmlOverride.getxPathExpression()), MojoExecutor.element(MojoExecutor.name("attributeName"), xmlOverride.getAttributeName()), MojoExecutor.element(MojoExecutor.name("value"), xmlOverride.getValue()))).toArray(MojoExecutor.Element[]::new);
        return MojoExecutor.element(MojoExecutor.name("xmlReplacements"), xmlReplacementsElements);
    }

    private Xpp3Dom getCargoStartConfiguration(File productWar, Map<String, String> systemProperties, List<ProductArtifact> extraContainerDependencies, List<ProductArtifact> extraProductDeployables, ContainerConfig containerConfig, MavenContext mavenContext) throws MojoExecutionException {
        Container container = containerConfig.getContainer();
        Product product = containerConfig.getProduct();
        return WebAppManagerImpl.configurationWithoutNullElements(MojoExecutor.element(MojoExecutor.name("deployables"), this.getDeployables(productWar, extraProductDeployables, product)), MojoExecutor.element(MojoExecutor.name("container"), MojoExecutor.element(MojoExecutor.name("containerId"), container.getId()), MojoExecutor.element(MojoExecutor.name("type"), container.getType()), MojoExecutor.element(MojoExecutor.name("home"), containerConfig.getInstallDirectory(mavenContext.getBuildDirectory())), MojoExecutor.element(MojoExecutor.name("output"), containerConfig.getLogFile()), MojoExecutor.element(MojoExecutor.name("systemProperties"), this.getContainerSystemProperties(systemProperties, product, containerConfig.getNode())), MojoExecutor.element(MojoExecutor.name("dependencies"), this.getContainerDependencies(extraContainerDependencies, product)), MojoExecutor.element(MojoExecutor.name("timeout"), String.valueOf(this.getStartupTimeout(product)))), MojoExecutor.element(MojoExecutor.name("configuration"), WebAppManagerImpl.removeNullElements(MojoExecutor.element(MojoExecutor.name("configfiles"), this.getExtraContainerConfigurationFiles(containerConfig)), MojoExecutor.element(MojoExecutor.name("home"), containerConfig.getConfigDirectory(mavenContext.getBuildDirectory())), MojoExecutor.element(MojoExecutor.name("type"), "standalone"), MojoExecutor.element(MojoExecutor.name(PROPERTIES), this.getConfigurationProperties(systemProperties, containerConfig)), this.xmlReplacementsElement(product.getCargoXmlOverrides()))), MojoExecutor.element(MojoExecutor.name("deployer"), new MojoExecutor.Element[0]));
    }

    @VisibleForTesting
    MojoExecutor.Element[] getConfigurationProperties(Map<String, String> systemProperties, ContainerConfig containerConfig) {
        Product product = containerConfig.getProduct();
        Node node = containerConfig.getNode();
        ArrayList<MojoExecutor.Element> props = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
            props.add(MojoExecutor.element(MojoExecutor.name(entry.getKey()), entry.getValue()));
        }
        props.add(MojoExecutor.element(MojoExecutor.name("cargo.servlet.port"), String.valueOf(node.getWebPort())));
        if (containerConfig.getContainer().getId().startsWith("tomcat")) {
            props.add(MojoExecutor.element(MojoExecutor.name(SERVLET_USER_PROPERTY), "admin:" + WebAppManagerImpl.generateStrongPassword() + ":manager-script"));
        }
        if (Boolean.TRUE.equals(product.getUseHttps())) {
            this.getLogger().debug("starting Tomcat using HTTPS via Cargo with the following parameters:");
            this.getLogger().debug("cargo.servlet.port = " + node.getWebPort());
            this.getLogger().debug("cargo.protocol = " + product.getProtocol());
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.protocol"), product.getProtocol()));
            this.getLogger().debug("cargo.tomcat.connector.clientAuth = " + product.getHttpsClientAuth());
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.connector.clientAuth"), product.getHttpsClientAuth()));
            this.getLogger().debug("cargo.tomcat.connector.sslProtocol = " + product.getHttpsSSLProtocol());
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.connector.sslProtocol"), product.getHttpsSSLProtocol()));
            this.getLogger().debug("cargo.tomcat.connector.keystoreFile = " + product.getHttpsKeystoreFile());
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.connector.keystoreFile"), product.getHttpsKeystoreFile()));
            this.getLogger().debug("cargo.tomcat.connector.keystorePass = " + product.getHttpsKeystorePass());
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.connector.keystorePass"), product.getHttpsKeystorePass()));
            this.getLogger().debug("cargo.tomcat.connector.keyAlias = " + product.getHttpsKeyAlias());
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.connector.keyAlias"), product.getHttpsKeyAlias()));
            this.getLogger().debug("cargo.tomcat.httpSecure = " + product.getHttpsHttpSecure());
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.httpSecure"), product.getHttpsHttpSecure().toString()));
        }
        props.add(MojoExecutor.element(MojoExecutor.name(AJP_PORT_PROPERTY), String.valueOf(node.getAjpPort())));
        props.add(MojoExecutor.element(MojoExecutor.name("cargo.rmi.port"), String.valueOf(node.getRmiPort())));
        props.add(MojoExecutor.element(MojoExecutor.name("cargo.jvmargs"), product.getJvmArgs() + node.getDebugArgs()));
        return props.toArray(new MojoExecutor.Element[0]);
    }

    static String generateStrongPassword() {
        int passwordLength = 16;
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^*()-_=+";
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder(16);
        for (int i = 0; i < 16; ++i) {
            sb.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^*()-_=+".charAt(random.nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^*()-_=+".length())));
        }
        return sb.toString();
    }

    private static Xpp3Dom configurationWithoutNullElements(MojoExecutor.Element ... elements) {
        return MojoExecutor.configuration(WebAppManagerImpl.removeNullElements(elements));
    }

    private static MojoExecutor.Element[] removeNullElements(MojoExecutor.Element ... elements) {
        return (MojoExecutor.Element[])Arrays.stream(elements).filter(Objects::nonNull).toArray(MojoExecutor.Element[]::new);
    }

    private MojoExecutor.Element[] getContainerSystemProperties(Map<String, String> systemProperties, Product product, Node node) {
        HashMap<String, String> containerSystemProperties = new HashMap<String, String>(systemProperties);
        containerSystemProperties.put("baseurl", product.getBaseUrlForPort(node.getWebPort()));
        return (MojoExecutor.Element[])containerSystemProperties.entrySet().stream().map(e -> MojoExecutor.element(MojoExecutor.name((String)e.getKey()), (String)e.getValue())).toArray(MojoExecutor.Element[]::new);
    }

    private int getStartupTimeout(Product product) {
        if (Boolean.FALSE.equals(product.getSynchronousStartup())) {
            return 0;
        }
        return product.getStartupTimeout();
    }

    private Container getCustomContainer(Product product) {
        String customContainerArtifactStr = product.getCustomContainerArtifact().trim();
        Object[] containerData = customContainerArtifactStr.split(":");
        if (containerData.length < 3 || containerData.length > 5) {
            throw new IllegalArgumentException(String.format("Container artifact string must have the format groupId:artifactId:version[:packaging:classifier] or groupId:artifactId:version:classifier; actual string = '%s'", customContainerArtifactStr));
        }
        String cargoContainerId = Containers.findContainer(product.getContainerId()).getId();
        String groupId = containerData[0];
        String artifactId = containerData[1];
        String version = containerData[2];
        switch (containerData.length) {
            case 3: {
                return new Container(cargoContainerId, groupId, artifactId, version);
            }
            case 4: {
                return new Container(cargoContainerId, groupId, artifactId, version, containerData[3]);
            }
            case 5: {
                return new Container(cargoContainerId, groupId, artifactId, version, containerData[4]);
            }
        }
        throw new IllegalStateException(String.format("Unexpected container data %s", Arrays.toString(containerData)));
    }

    private MojoExecutor.Element[] getContainerDependencies(List<ProductArtifact> extraContainerDependencies, Product product) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> dependencyElements = new ArrayList<MojoExecutor.Element>();
        ArrayList<ProductArtifact> containerDependencies = new ArrayList<ProductArtifact>(extraContainerDependencies);
        product.getDataSources().forEach(ds -> containerDependencies.addAll(ds.getLibArtifacts()));
        for (ProductArtifact containerDependency : containerDependencies) {
            dependencyElements.add(MojoExecutor.element(MojoExecutor.name("dependency"), MojoExecutor.element(MojoExecutor.name("location"), product.getArtifactRetriever().resolve(containerDependency))));
        }
        return dependencyElements.toArray(new MojoExecutor.Element[0]);
    }

    private MojoExecutor.Element[] getExtraContainerConfigurationFiles(ContainerConfig containerConfig) throws MojoExecutionException {
        return new MojoExecutor.Element[]{MojoExecutor.element("configfile", MojoExecutor.element("file", this.getContextXml(containerConfig).getAbsolutePath()), MojoExecutor.element("todir", "conf"), MojoExecutor.element("tofile", "context.xml"), MojoExecutor.element("configfile", "true"))};
    }

    private MojoExecutor.Element[] getDeployables(File productWar, List<ProductArtifact> extraDeployables, Product webappContext) {
        ArrayList<MojoExecutor.Element> deployables = new ArrayList<MojoExecutor.Element>();
        deployables.add(MojoExecutor.element(MojoExecutor.name("deployable"), MojoExecutor.element(MojoExecutor.name("groupId"), "foo"), MojoExecutor.element(MojoExecutor.name("artifactId"), "bar"), MojoExecutor.element(MojoExecutor.name("type"), "war"), MojoExecutor.element(MojoExecutor.name("location"), productWar.getPath()), MojoExecutor.element(MojoExecutor.name(PROPERTIES), MojoExecutor.element(MojoExecutor.name("context"), webappContext.getContextPath()))));
        for (ProductArtifact artifact : extraDeployables) {
            deployables.add(MojoExecutor.element(MojoExecutor.name("deployable"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("type"), artifact.getType()), MojoExecutor.element(MojoExecutor.name("location"), artifact.getPath())));
        }
        return deployables.toArray(new MojoExecutor.Element[0]);
    }

    private Container getContainer(Product product) {
        if (product.getCustomContainerArtifact() == null) {
            return Containers.findContainer(product.getContainerId());
        }
        return this.getCustomContainer(product);
    }

    private void unpackOrReuse(ContainerConfig containerConfig, MavenContext mavenContext) throws MojoExecutionException {
        Container container = containerConfig.getContainer();
        File containerDir = new File(containerConfig.getInstallDirectory(mavenContext.getBuildDirectory()));
        if (containerDir.isDirectory()) {
            this.getLogger().info("Reusing unpacked container '" + container.getId() + "' from " + containerDir.getPath());
        } else if (containerConfig.isFirstNode()) {
            this.getLogger().info("Unpacking container '" + container.getId() + "' from container artifact: " + container);
            this.unpackContainer(container, mavenContext);
        } else {
            this.getLogger().info("Reusing container '" + container.getId() + "' from node 0");
            File nodeZeroContainerDir = new File(containerDir.getParentFile(), container.getFileName());
            try {
                FileUtils.copyDirectory((File)nodeZeroContainerDir, (File)containerDir);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void unpackContainer(Container container, MavenContext mavenContext) throws MojoExecutionException {
        this.mojoExecutorWrapper.executeWithMergedConfig(mavenContext.getPlugin("org.apache.maven.plugins", "maven-dependency-plugin"), MojoExecutor.goal("unpack"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), container.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), container.getArtifactId()), MojoExecutor.element(MojoExecutor.name("version"), container.getVersion()), MojoExecutor.element(MojoExecutor.name("classifier"), container.getClassifier()), MojoExecutor.element(MojoExecutor.name("type"), "zip"))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), container.getRootDirectory(mavenContext.getBuildDirectory()))), mavenContext.getExecutionEnvironment());
    }

    File getContextXml(ContainerConfig containerConfig) throws MojoExecutionException {
        try {
            Product product = containerConfig.getProduct();
            File tempContextXml = File.createTempFile("context.xml", null);
            InputStream contextXmlToCopy = Objects.requireNonNull(this.getClass().getResourceAsStream("context.xml"));
            Consumer<Document> modifier = product.getContextXmlModifier();
            if (modifier != null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                factory.setExpandEntityReferences(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document contextXml = builder.parse(contextXmlToCopy);
                modifier.accept(contextXml);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(contextXml);
                StreamResult result = new StreamResult(tempContextXml);
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(source, result);
            } else {
                FileUtils.copyInputStreamToFile((InputStream)contextXmlToCopy, (File)tempContextXml);
            }
            return tempContextXml;
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new MojoExecutionException("Failed to create Tomcat context.xml", e);
        }
    }

    private Plugin cargoPlugin(MavenContext mavenContext) {
        Plugin cargoPlugin = mavenContext.getPlugin("org.codehaus.cargo", "cargo-maven3-plugin");
        this.getLogger().info("using codehaus cargo v" + cargoPlugin.getVersion());
        return cargoPlugin;
    }

    @Override
    public void stopWebapp(Product product, MavenContext mavenContext) throws MojoExecutionException {
        Container container = this.getContainer(product);
        int shutdownTimeout = Boolean.TRUE.equals(product.getSynchronousStartup()) ? 0 : product.getShutdownTimeout();
        for (Node node : product.getNodes()) {
            this.stopNode(container, product, node, mavenContext, shutdownTimeout);
        }
    }

    private void stopNode(Container container, Product product, Node node, MavenContext mavenContext, int shutdownTimeout) throws MojoExecutionException {
        this.mojoExecutorWrapper.execute(this.cargoPlugin(mavenContext), MojoExecutor.goal("stop"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("container"), MojoExecutor.element(MojoExecutor.name("containerId"), container.getId()), MojoExecutor.element(MojoExecutor.name("type"), container.getType()), MojoExecutor.element(MojoExecutor.name("timeout"), String.valueOf(shutdownTimeout)), MojoExecutor.element(MojoExecutor.name("home"), container.getInstallDirectory(mavenContext.getBuildDirectory()))), MojoExecutor.element(MojoExecutor.name("configuration"), MojoExecutor.element(MojoExecutor.name("home"), container.getConfigDirectory(mavenContext.getBuildDirectory(), product.getInstanceId())), MojoExecutor.element(MojoExecutor.name(PROPERTIES), this.createShutdownPortsPropertiesConfiguration(node)))), mavenContext.getExecutionEnvironment());
    }

    private MojoExecutor.Element[] createShutdownPortsPropertiesConfiguration(Node node) {
        String webPort = String.valueOf(node.getWebPort());
        ArrayList<MojoExecutor.Element> properties = new ArrayList<MojoExecutor.Element>();
        properties.add(MojoExecutor.element(MojoExecutor.name("cargo.servlet.port"), webPort));
        properties.add(MojoExecutor.element(MojoExecutor.name(AJP_PORT_PROPERTY), webPort));
        return properties.toArray(new MojoExecutor.Element[0]);
    }
}

