/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class ProductContainerVersionMapper {
    private static final Map<String, TreeMap<ComparableVersion, String>> productMapping = new HashMap<String, TreeMap<ComparableVersion, String>>();
    public static final String TOMCAT6X = "tomcat6x";
    public static final String TOMCAT7X = "tomcat7x";
    public static final String TOMCAT8X = "tomcat8x";
    public static final String TOMCAT85X = "tomcat85x";
    public static final String TOMCAT9X = "tomcat9x";
    public static final String TOMCAT10X = "tomcat10x";
    public static final String DEFAULT_CONTAINER = "tomcat9x";

    private static String adjustToLowestVersion(String version) {
        return version + "-alpha";
    }

    private static void populateVersionMapForJira(Map<String, String> productToTomcatVersions) {
        TreeMap<ComparableVersion, String> jiraTomcatVersions = new TreeMap<ComparableVersion, String>();
        for (Map.Entry<String, String> entry : productToTomcatVersions.entrySet()) {
            jiraTomcatVersions.put(new ComparableVersion(ProductContainerVersionMapper.adjustToLowestVersion(entry.getKey())), entry.getValue());
        }
        productMapping.put("jira", jiraTomcatVersions);
    }

    private static void populateVersionMapForProduct(String productId, String tomcat6Version, String tomcat7Version, String tomcat8Version, String tomcat85Version, String tomcat9Version, String tomcat10Version) {
        TreeMap<ComparableVersion, String> versions = new TreeMap<ComparableVersion, String>();
        if (tomcat6Version != null) {
            versions.put(new ComparableVersion(ProductContainerVersionMapper.adjustToLowestVersion(tomcat6Version)), TOMCAT6X);
        }
        if (tomcat7Version != null) {
            versions.put(new ComparableVersion(ProductContainerVersionMapper.adjustToLowestVersion(tomcat7Version)), TOMCAT7X);
        }
        if (tomcat8Version != null) {
            versions.put(new ComparableVersion(ProductContainerVersionMapper.adjustToLowestVersion(tomcat8Version)), TOMCAT8X);
        }
        if (tomcat85Version != null) {
            versions.put(new ComparableVersion(ProductContainerVersionMapper.adjustToLowestVersion(tomcat85Version)), TOMCAT85X);
        }
        if (tomcat9Version != null) {
            versions.put(new ComparableVersion(ProductContainerVersionMapper.adjustToLowestVersion(tomcat9Version)), "tomcat9x");
        }
        if (tomcat10Version != null) {
            versions.put(new ComparableVersion(ProductContainerVersionMapper.adjustToLowestVersion(tomcat10Version)), TOMCAT10X);
        }
        productMapping.put(productId, versions);
    }

    public static String containerForProductVersion(String productId, @Nullable String version) {
        Map.Entry<ComparableVersion, String> entry;
        if (version == null) {
            version = "LATEST";
        }
        ComparableVersion productVersion = new ComparableVersion(version);
        TreeMap<ComparableVersion, String> versions = productMapping.get(productId);
        String containerId = null;
        if (versions != null && (entry = versions.floorEntry(productVersion)) != null) {
            containerId = entry.getValue();
        }
        if (containerId == null) {
            containerId = "tomcat9x";
        }
        return containerId;
    }

    private ProductContainerVersionMapper() {
    }

    static {
        ProductContainerVersionMapper.populateVersionMapForProduct("bamboo", "0", "5.1", "5.10", null, "9.2", "12.0.0");
        ProductContainerVersionMapper.populateVersionMapForProduct("bitbucket", null, null, "1", null, "6.0.0", "10.0.");
        ProductContainerVersionMapper.populateVersionMapForProduct("confluence", "0", "5.5", "5.8", null, "6.10", "10.0.0");
        ProductContainerVersionMapper.populateVersionMapForProduct("crowd", "0", "2.7.0", null, "3.1.0", "5.2.0", "7.0.0");
        ProductContainerVersionMapper.populateVersionMapForJira((Map<String, String>)new ImmutableMap.Builder().put((Object)"0", (Object)TOMCAT6X).put((Object)"5.2", (Object)TOMCAT7X).put((Object)"7.0.0", (Object)TOMCAT8X).put((Object)"7.3.0", (Object)"tomcat85_6").put((Object)"7.6.0", (Object)"tomcat85_29").put((Object)"7.12.0", (Object)"tomcat85_32").put((Object)"7.13.0", (Object)"tomcat85_35").put((Object)"8.2.1", (Object)TOMCAT85X).put((Object)"9.0.0", (Object)"tomcat9x").put((Object)"11.0.0", (Object)TOMCAT10X).build());
        ProductContainerVersionMapper.populateVersionMapForProduct("refapp", "0", "2.21.0", "3.0.0", "5.0.0", "6.0.0", "8.0.0");
    }
}

