/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Node;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.license.LicenseInstaller;
import com.atlassian.maven.plugins.amps.product.AmpsDefaults;
import com.atlassian.maven.plugins.amps.product.ApplicationMapper;
import com.atlassian.maven.plugins.amps.product.GroupArtifactPair;
import com.atlassian.maven.plugins.amps.product.JavaModulePackage;
import com.atlassian.maven.plugins.amps.product.PluginProvider;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.util.ArtifactResolutionException;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.atlassian.maven.plugins.amps.util.JvmArgsFix;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.atlassian.maven.plugins.amps.util.ZipUtils;
import com.atlassian.upm.signing.tool.UpmConfigHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractProductHandler
implements ProductHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProductHandler.class);
    private static final Map<String, Map<String, GroupArtifactPair>> APPLICATION_KEYS = ImmutableMap.of((Object)"jira", (Object)ImmutableMap.of((Object)"jira-software", (Object)new GroupArtifactPair("com.atlassian.jira", "jira-software-application"), (Object)"jira-servicedesk", (Object)new GroupArtifactPair("com.atlassian.servicedesk", "jira-servicedesk-application")));
    private static final String TOMCAT_LIB_DIR = "WEB-INF/lib";
    protected static final Set<JavaModulePackage> ADD_OPENS_FOR_TOMCAT = ImmutableSet.of((Object)JavaModulePackage.fromJavaBaseModule("java.lang"), (Object)JavaModulePackage.fromJavaBaseModule("java.io"), (Object)JavaModulePackage.fromJavaRmiModule("sun.rmi.transport"));
    protected static final Set<JavaModulePackage> ADD_OPENS_FOR_FELIX = ImmutableSet.of((Object)JavaModulePackage.fromJavaBaseModule("java.lang"), (Object)JavaModulePackage.fromJavaBaseModule("java.net"), (Object)JavaModulePackage.fromJavaBaseModule("sun.net.www.protocol.jar"), (Object)JavaModulePackage.fromJavaBaseModule("sun.net.www.protocol.file"), (Object)JavaModulePackage.fromJavaBaseModule("sun.net.www.protocol.http"), (Object)JavaModulePackage.fromJavaBaseModule("sun.net.www.protocol.https"), (Object[])new JavaModulePackage[0]);
    protected final Log log;
    protected final MavenContext context;
    protected final MavenGoals goals;
    protected final MavenProject project;
    protected final RepositorySystem repositorySystem;
    private final ApplicationMapper applicationMapper = new ApplicationMapper(APPLICATION_KEYS);
    private final ArtifactResolver artifactResolver;
    private final PluginProvider pluginProvider;

    @VisibleForTesting
    static String propertiesEncode(String raw) {
        if (raw == null) {
            return null;
        }
        return raw.replaceAll(":", "\\:").replaceAll("=", "\\=");
    }

    protected AbstractProductHandler(MavenContext context, MavenGoals goals, PluginProvider pluginProvider, RepositorySystem repositorySystem, ArtifactResolver artifactResolver) {
        this.artifactResolver = Objects.requireNonNull(artifactResolver);
        this.context = Objects.requireNonNull(context);
        this.goals = Objects.requireNonNull(goals);
        this.log = Objects.requireNonNull(context.getLog());
        this.pluginProvider = Objects.requireNonNull(pluginProvider);
        this.project = Objects.requireNonNull(context.getProject());
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
    }

    @Override
    public void createHomeZip(@Nonnull File homeDirectory, @Nonnull File targetZip, @Nonnull Product product) throws MojoExecutionException {
        if (!homeDirectory.exists()) {
            String homePath = homeDirectory.getAbsolutePath();
            this.context.getLog().info((CharSequence)("home directory doesn't exist, skipping. [" + homePath + "]"));
            return;
        }
        try {
            File appDir = this.getBaseDirectory(product);
            File tmpDir = new File(appDir, "tmp-resources");
            File homeSnapshot = new File(tmpDir, "generated-home");
            String entryBase = "generated-resources/" + product.getId() + "-home";
            if (homeSnapshot.exists()) {
                org.apache.commons.io.FileUtils.deleteDirectory((File)homeSnapshot);
            }
            FileUtils.makeDirectories(homeSnapshot);
            FileUtils.copyDirectory(homeDirectory, homeSnapshot, true);
            this.cleanupProductHomeForZip(product, homeSnapshot);
            ZipUtils.zipDir(targetZip, homeSnapshot, entryBase);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error zipping home directory", e);
        }
    }

    protected void cleanupProductHomeForZip(@Nonnull Product product, @Nonnull File snapshotDir) throws MojoExecutionException, IOException {
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)new File(snapshotDir, "plugins"));
            org.apache.commons.io.FileUtils.deleteDirectory((File)new File(snapshotDir, "bundled-plugins"));
            this.getTestResourcesArtifact().ifPresent(testResourcesArtifact -> {
                String originalHomeZip = testResourcesArtifact.getArtifactId() + ".zip";
                org.apache.commons.io.FileUtils.deleteQuietly((File)new File(snapshotDir, originalHomeZip));
            });
            this.undoReplacements(product, snapshotDir);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not delete home/plugins/ and /home/bundled-plugins/", (Exception)ioe);
        }
    }

    private void undoReplacements(Product product, File snapshotDir) throws MojoExecutionException {
        List<ConfigFileUtils.Replacement> replacements = this.getReplacements(product, 0);
        Collections.sort(replacements);
        List<File> files = this.getConfigFiles(product, snapshotDir);
        ConfigFileUtils.replace(files, replacements, true);
    }

    @Override
    @Nonnull
    public final List<Node> start(@Nonnull Product product) throws MojoExecutionException {
        List<File> homeDirs = this.extractAndProcessHomeDirectories(product);
        File extractedApp = this.extractApplication(product);
        File finalApp = this.addArtifactsAndOverrides(product, homeDirs, extractedApp);
        this.addOverridesFromProductPom(product);
        UpmConfigHandler upmConfigHandler = product.getUpmConfigHandler();
        if (upmConfigHandler != null) {
            upmConfigHandler.writeConfiguration();
        }
        List<Map<String, String>> systemProperties = this.mergeSystemProperties(product);
        List<Node> nodes = this.startProduct(product, finalApp, systemProperties);
        if (this.useBackdoorToInstallLicense()) {
            new LicenseInstaller(this.log).installLicense(product, nodes.get(0).getWebPort());
        }
        return nodes;
    }

    @Override
    public void stop(@Nonnull Product product) throws MojoExecutionException {
        this.addOverridesFromProductPom(product);
        UpmConfigHandler upmConfigHandler = product.getUpmConfigHandler();
        if (upmConfigHandler != null) {
            this.log.info((CharSequence)("Call UPM config shutdown action on " + product.getId() + " stop"));
            upmConfigHandler.shutdown();
        }
    }

    protected boolean useBackdoorToInstallLicense() {
        return true;
    }

    protected void addOverridesFromProductPom(Product product) throws MojoExecutionException {
    }

    @Override
    @Nonnull
    public String getDefaultContainerId() {
        return "tomcat9x";
    }

    @Override
    @Nonnull
    public String resolveProductVersion(@Nonnull Product product) throws MojoExecutionException {
        String version = product.getVersion();
        if (StringUtils.isBlank((CharSequence)version)) {
            version = "RELEASE";
        }
        if ("RELEASE".equals(version) || "LATEST".equals(version)) {
            ProductArtifact productArtifact = this.getArtifact();
            Artifact warArtifact = this.repositorySystem.createProjectArtifact(productArtifact.getGroupId(), productArtifact.getArtifactId(), version);
            version = product.getArtifactRetriever().getLatestStableVersion(warArtifact);
        }
        return version;
    }

    @Override
    @Nonnull
    public String getDefaultContextPath() {
        return "/" + this.getId();
    }

    @Override
    @Nonnull
    public List<File> getHomeDirectories(@Nonnull Product product) {
        List<Node> nodes = product.getNodes();
        if (StringUtils.isBlank((CharSequence)product.getDataHome())) {
            ArrayList<File> homeDirectories = new ArrayList<File>();
            for (int nodeIndex = 0; nodeIndex < nodes.size(); ++nodeIndex) {
                String directorySuffix = nodeIndex == 0 ? "" : "-" + nodeIndex;
                homeDirectories.add(new File(this.getBaseDirectory(product), "home" + directorySuffix));
            }
            return homeDirectories;
        }
        switch (nodes.size()) {
            case 0: {
                throw new IllegalStateException("Must be at least one node");
            }
            case 1: {
                return Collections.singletonList(new File(product.getDataHome()));
            }
        }
        throw new UnsupportedOperationException("You cannot specify a custom <dataHome> directory when multiple nodes are being started");
    }

    private List<File> extractAndProcessHomeDirectories(Product product) throws MojoExecutionException {
        List<File> homeDirectories = this.getHomeDirectories(product);
        List<Node> nodes = product.getNodes();
        if (nodes.size() == 1 && StringUtils.isNotBlank((CharSequence)product.getDataHome())) {
            return homeDirectories;
        }
        File productHomeData = this.getProductHomeData(product);
        if (productHomeData != null) {
            for (int i = 0; i < nodes.size(); ++i) {
                File homeDirectory = homeDirectories.get(i);
                this.extractAndProcessHomeDirectory(product, productHomeData, homeDirectory, i);
            }
        }
        return homeDirectories;
    }

    private void extractAndProcessHomeDirectory(Product product, File productHomeData, File homeDirectory, int nodeIndex) throws MojoExecutionException {
        if (!homeDirectory.exists()) {
            this.extractProductHomeData(productHomeData, homeDirectory, product);
            FileUtils.makeDirectory(homeDirectory);
            this.processHomeDirectory(product, nodeIndex, homeDirectory);
        }
        this.overrideAndPatchHomeDir(homeDirectory, product);
    }

    @Nullable
    private File getProductHomeData(Product product) throws MojoExecutionException {
        String dataPath = product.getDataPath();
        if (StringUtils.isNotBlank((CharSequence)dataPath)) {
            File dataPathAsFile = new File(dataPath);
            if (dataPathAsFile.exists()) {
                return dataPathAsFile;
            }
            throw new MojoExecutionException("Unable to use custom test resources set by <dataPath>. '" + dataPathAsFile.getAbsolutePath() + "' does not exist");
        }
        File productHomeZip = null;
        Optional<ProductArtifact> maybeTestResourcesArtifact = this.getTestResourcesArtifact();
        if (maybeTestResourcesArtifact.isPresent()) {
            ProductArtifact testResourcesArtifact = maybeTestResourcesArtifact.get();
            if (StringUtils.isBlank((CharSequence)product.getDataVersion()) || "RELEASE".equals(product.getDataVersion()) || "LATEST".equals(product.getDataVersion())) {
                this.setLatestDataVersion(product, testResourcesArtifact);
            }
            ProductArtifact testResources = new ProductArtifact(testResourcesArtifact.getGroupId(), testResourcesArtifact.getArtifactId(), product.getDataVersion());
            productHomeZip = this.goals.copyZip(this.getBaseDirectory(product), testResources, testResources.getArtifactId() + ".zip");
        }
        return productHomeZip;
    }

    private void setLatestDataVersion(Product product, ProductArtifact testResourcesArtifact) throws MojoExecutionException {
        this.log.info((CharSequence)"determining latest stable data version...");
        Artifact dataArtifact = this.repositorySystem.createProjectArtifact(testResourcesArtifact.getGroupId(), testResourcesArtifact.getArtifactId(), product.getDataVersion());
        String stableVersion = product.getArtifactRetriever().getLatestStableVersion(dataArtifact);
        this.log.info((CharSequence)("using latest stable data version: " + stableVersion));
        testResourcesArtifact.setVersion(stableVersion);
        product.setDataVersion(stableVersion);
    }

    private void extractProductHomeData(File productHomeData, File homeDir, Product product) throws MojoExecutionException {
        File tmpDir = new File(this.getBaseDirectory(product), "tmp-resources");
        FileUtils.makeDirectory(tmpDir);
        try {
            if (productHomeData.isFile()) {
                File tmp = new File(this.getBaseDirectory(product), product.getId() + "-home");
                ZipUtils.unzip(productHomeData, tmpDir.getPath());
                File rootDir = this.getRootDir(tmpDir, product);
                FileUtils.copyDirectory(rootDir, this.getBaseDirectory(product), true);
                org.apache.commons.io.FileUtils.moveDirectory((File)tmp, (File)homeDir);
            } else if (productHomeData.isDirectory()) {
                FileUtils.copyDirectory(productHomeData, homeDir, true);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to copy home directory", (Exception)ex);
        }
    }

    private void overrideAndPatchHomeDir(File homeDir, Product product) throws MojoExecutionException {
        File srcDir = null;
        String overridesPath = product.getDataOverridesPath();
        if (StringUtils.isNotBlank((CharSequence)overridesPath) && !(srcDir = new File(overridesPath)).isDirectory()) {
            srcDir = new File(this.project.getBasedir(), overridesPath);
        }
        if (srcDir == null || !srcDir.isDirectory()) {
            srcDir = new File(this.project.getBasedir(), "src/test/resources/" + product.getInstanceId() + "-home");
        }
        try {
            if (srcDir.exists() && homeDir.exists()) {
                FileUtils.copyDirectory(srcDir, homeDir, false);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to override files using " + srcDir.getAbsolutePath(), (Exception)e);
        }
    }

    @Nonnull
    protected File getRootDir(File tmpDir, Product product) throws MojoExecutionException, IOException {
        File[] topLevelFiles = tmpDir.listFiles();
        if (topLevelFiles == null) {
            throw new MojoExecutionException("Could not read files in " + tmpDir);
        }
        switch (topLevelFiles.length) {
            case 0: {
                throw new MojoExecutionException("No files in " + tmpDir);
            }
            case 1: {
                return topLevelFiles[0];
            }
        }
        String filenames = Arrays.stream(topLevelFiles).map(File::getName).collect(Collectors.joining(", "));
        throw new MojoExecutionException("Expected a single top-level directory in test resources, but found: " + filenames);
    }

    private File addArtifactsAndOverrides(Product product, List<File> homeDirs, File productFile) throws MojoExecutionException {
        try {
            File productDir;
            if (productFile.isFile()) {
                productDir = new File(this.getBaseDirectory(product), "webapp");
                if (!productDir.exists()) {
                    ZipUtils.unzip(productFile, productDir.getAbsolutePath());
                }
            } else {
                productDir = productFile;
            }
            for (File homeDir : homeDirs) {
                this.addArtifacts(product, homeDir, productDir);
                this.overrideWarFiles(product, homeDir, productDir);
            }
            if (productFile.isFile()) {
                File warFile = new File(productFile.getParentFile(), this.getId() + ".war");
                ZipUtils.zipChildren(warFile, productDir);
                return warFile;
            }
            return productDir;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void overrideWarFiles(Product product, File homeDir, File appDir) throws MojoExecutionException {
        try {
            this.addOverrides(appDir, product);
            this.customiseInstance(product, homeDir, appDir);
            this.fixJvmArgs(product, appDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to override WAR files using src/test/resources/" + product.getInstanceId() + "-app", (Exception)e);
        }
    }

    protected void customiseInstance(Product product, File homeDir, File explodedWarDir) throws MojoExecutionException {
    }

    protected void fixJvmArgs(Product product, File appDir) {
        this.fixJvmArgs(product);
    }

    protected void fixJvmArgs(Product product) {
        String jvmArgs = JvmArgsFix.defaults().apply(product.getJvmArgs());
        product.setJvmArgs(jvmArgs);
    }

    private void addArtifacts(Product product, File homeDir, File appDir) throws IOException, MojoExecutionException {
        Optional<String> log4j2ConfigPath;
        Optional<String> log4jPropertiesPath;
        File pluginsDir = this.getUserInstalledPluginsDirectory(product, appDir, homeDir).orElse(null);
        File bundledPluginsDir = new File(this.getBaseDirectory(product), "bundled-plugins");
        FileUtils.makeDirectory(bundledPluginsDir);
        File bundledPluginsFile = this.getBundledPluginPath(product, appDir);
        if (bundledPluginsFile.exists()) {
            if (bundledPluginsFile.isDirectory()) {
                bundledPluginsDir = bundledPluginsFile;
            } else {
                ZipUtils.unzip(bundledPluginsFile, bundledPluginsDir.getPath());
            }
        }
        if (this.isStaticPlugin()) {
            if (!this.supportsStaticPlugins()) {
                throw new MojoExecutionException("According to your atlassian-plugin.xml file, this plugin is not atlassian-plugins version 2. This app currently only supports atlassian-plugins version 2.");
            }
            pluginsDir = new File(appDir, TOMCAT_LIB_DIR);
        }
        if (pluginsDir == null) {
            pluginsDir = bundledPluginsDir;
        }
        ProjectUtils.createDirectory(pluginsDir);
        ProductArtifact selfInstalled = null;
        if (Boolean.TRUE.equals(product.isInstallPlugin())) {
            this.addThisPluginToDirectory(pluginsDir);
            this.addTestPluginToDirectory(pluginsDir);
            selfInstalled = ProductArtifact.fromArtifact(this.project.getArtifact());
        }
        if (!this.isStaticPlugin()) {
            this.addArtifactsToDirectory(this.pluginProvider.provide(product, selfInstalled), pluginsDir);
        }
        this.addArtifactsToDirectory(product.getLibArtifacts(), new File(appDir, this.getLibArtifactTargetDir()));
        List<ProductArtifact> applications = this.applicationMapper.provideApplications(product);
        this.extractApplicationPlugins(applications, pluginsDir);
        ArrayList<ProductArtifact> plugins = new ArrayList<ProductArtifact>();
        plugins.addAll(product.getBundledArtifacts());
        plugins.addAll(this.getAdditionalPlugins(product));
        if (product.hasUserConfiguredLicense() && this.useBackdoorToInstallLicense()) {
            plugins.add(new ProductArtifact("com.atlassian.platform", "license-backdoor-plugin", AmpsDefaults.forProduct((Product)product).defaultLicenseBackdoorVersion));
        }
        this.addArtifactsToDirectory(plugins, bundledPluginsDir);
        String[] bundledPlugins = bundledPluginsDir.list();
        if (bundledPlugins != null && bundledPlugins.length > 0 && !bundledPluginsFile.isDirectory()) {
            ZipUtils.zipChildren(bundledPluginsFile, bundledPluginsDir);
        }
        if (product.getLog4jProperties() != null && (log4jPropertiesPath = this.getLog4jPropertiesPath()).isPresent()) {
            org.apache.commons.io.FileUtils.copyFile((File)product.getLog4jProperties(), (File)new File(appDir, log4jPropertiesPath.get()));
        }
        if (product.getLog4j2Config() != null && (log4j2ConfigPath = this.getLog4j2ConfigPath()).isPresent()) {
            org.apache.commons.io.FileUtils.copyFile((File)product.getLog4j2Config(), (File)new File(appDir, log4j2ConfigPath.get()));
        }
    }

    protected void processHomeDirectory(Product product, int nodeIndex, File homeDir) throws MojoExecutionException {
        ConfigFileUtils.replace(this.getConfigFiles(product, homeDir), this.getReplacements(product, nodeIndex), false);
    }

    @Nonnull
    protected List<File> getConfigFiles(@Nonnull Product product, @Nonnull File snapshotDir) {
        return new ArrayList<File>();
    }

    @Override
    @Nonnull
    public File getBaseDirectory(@Nonnull Product ctx) {
        return ProjectUtils.createDirectory(new File(this.project.getBuild().getDirectory(), ctx.getInstanceId()));
    }

    @Nonnull
    protected List<ConfigFileUtils.Replacement> getReplacements(@Nonnull Product product, int nodeIndex) {
        ArrayList<ConfigFileUtils.Replacement> replacements = new ArrayList<ConfigFileUtils.Replacement>();
        String buildDirectory = this.project.getBuild().getDirectory();
        String baseDirectory = this.getBaseDirectory(product).getAbsolutePath();
        Optional<File> homeDirectory = this.getOnlyHomeDirectory(product);
        replacements.add(new ConfigFileUtils.Replacement("%PROJECT_BUILD_DIR%", buildDirectory));
        replacements.add(new ConfigFileUtils.Replacement("%PRODUCT_BASE_DIR%", baseDirectory));
        homeDirectory.ifPresent(homeDir -> replacements.add(new ConfigFileUtils.Replacement("%PRODUCT_HOME_DIR%", homeDir.getAbsolutePath())));
        replacements.add(AbstractProductHandler.replaceDirectory("%PROJECT_BUILD_DIR_URL_ENCODED%", buildDirectory));
        replacements.add(AbstractProductHandler.replaceDirectory("%PRODUCT_BASE_DIR_URL_ENCODED%", baseDirectory));
        homeDirectory.ifPresent(file -> replacements.add(AbstractProductHandler.replaceDirectory("%PRODUCT_HOME_DIR_URL_ENCODED%", file.getAbsolutePath())));
        replacements.add(ConfigFileUtils.Replacement.onlyWhenUnzipping("localhost", product.getServer()));
        try {
            String localHostName = InetAddress.getLocalHost().getHostName();
            replacements.add(new ConfigFileUtils.Replacement("%LOCAL_HOST_NAME%", localHostName));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return replacements;
    }

    private static ConfigFileUtils.Replacement replaceDirectory(String placeholder, String directory) {
        String encoding = StandardCharsets.UTF_8.name();
        try {
            return new ConfigFileUtils.Replacement(placeholder, URLEncoder.encode(AbstractProductHandler.propertiesEncode(directory), encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(encoding + " should be supported on any JVM", e);
        }
    }

    private Optional<File> getOnlyHomeDirectory(Product product) {
        List<File> homeDirectories = this.getHomeDirectories(product);
        if (homeDirectories.size() == 1) {
            return Optional.of(homeDirectories.get(0));
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public final List<File> getSnapshotDirectories(@Nonnull Product product) {
        return this.getHomeDirectories(product);
    }

    @Nonnull
    protected abstract File extractApplication(Product var1) throws MojoExecutionException;

    @Nonnull
    protected abstract List<Node> startProduct(Product var1, File var2, List<Map<String, String>> var3) throws MojoExecutionException;

    protected abstract boolean supportsStaticPlugins();

    @Nonnull
    protected abstract File getBundledPluginPath(Product var1, File var2);

    @Nonnull
    protected abstract Optional<File> getUserInstalledPluginsDirectory(Product var1, File var2, File var3);

    @Nonnull
    protected List<ProductArtifact> getAdditionalPlugins(Product product) throws MojoExecutionException {
        return Collections.emptyList();
    }

    @Nonnull
    protected Optional<String> getLog4jPropertiesPath() {
        return Optional.empty();
    }

    @Nonnull
    protected Optional<String> getLog4j2ConfigPath() {
        return Optional.empty();
    }

    protected boolean isStaticPlugin() throws IOException {
        File atlassianPluginXml = new File(this.project.getBasedir(), "src/main/resources/atlassian-plugin.xml");
        if (atlassianPluginXml.exists()) {
            String text = org.apache.commons.io.FileUtils.readFileToString((File)atlassianPluginXml, (Charset)StandardCharsets.UTF_8);
            String verTemplate = "%s=\"2\"";
            return !text.contains(String.format(verTemplate, "pluginsVersion")) && !text.contains(String.format(verTemplate, "plugins-version"));
        }
        return false;
    }

    private void addThisPluginToDirectory(File targetDir) throws IOException {
        File thisPlugin = this.getPluginFile();
        if (thisPlugin.exists()) {
            Iterator files = org.apache.commons.io.FileUtils.iterateFiles((File)targetDir, null, (boolean)false);
            while (files.hasNext()) {
                File file = (File)files.next();
                ProductArtifact thisPluginArtifact = new ProductArtifact(this.project.getGroupId(), this.project.getArtifactId());
                if (!FileUtils.doesFileNameMatchArtifact(file.getName(), thisPluginArtifact)) continue;
                Files.delete(file.toPath());
            }
            org.apache.commons.io.FileUtils.copyFile((File)thisPlugin, (File)new File(targetDir, thisPlugin.getName()));
        } else {
            this.log.info((CharSequence)("No plugin in the current project - " + thisPlugin.getAbsolutePath()));
        }
    }

    private void addTestPluginToDirectory(File targetDir) throws IOException {
        File testPluginFile = this.getTestPluginFile();
        if (testPluginFile.exists()) {
            org.apache.commons.io.FileUtils.copyFile((File)testPluginFile, (File)new File(targetDir, testPluginFile.getName()));
        }
    }

    private File getPluginFile() {
        return new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".jar");
    }

    private File getTestPluginFile() {
        return new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "-tests.jar");
    }

    private void addArtifactsToDirectory(List<ProductArtifact> artifacts, File pluginsDir) throws MojoExecutionException {
        if (!artifacts.isEmpty() && pluginsDir.isDirectory()) {
            org.apache.commons.io.FileUtils.listFiles((File)pluginsDir, null, (boolean)false).stream().filter(File::isFile).filter(file -> this.fileMatchesAnyArtifact((File)file, (Collection<ProductArtifact>)artifacts)).filter(org.apache.commons.io.FileUtils::deleteQuietly).forEach(f -> LOGGER.info("File {} was deleted and will be replaced", (Object)f.getName()));
            this.goals.copyPlugins(pluginsDir, artifacts);
        }
    }

    private boolean fileMatchesAnyArtifact(File file, Collection<ProductArtifact> artifacts) {
        Optional<ProductArtifact> overridingArtifact = artifacts.stream().filter(productArtifact -> FileUtils.doesFileNameMatchArtifact(file.getName(), productArtifact)).findFirst();
        if (overridingArtifact.isPresent()) {
            LOGGER.warn("Artifact shipped with the product '{}' will be replaced by '{}'.", (Object)file.getName(), (Object)overridingArtifact.get());
            return true;
        }
        return false;
    }

    private void extractApplicationPlugins(List<ProductArtifact> applications, File bundledPluginsDir) throws IOException {
        for (ProductArtifact application : applications) {
            File artifact = this.resolveApplicationArtifact(application).getFile();
            this.log.info((CharSequence)("Extracting " + artifact.getAbsolutePath() + " into " + bundledPluginsDir.getAbsolutePath()));
            ZipUtils.unzip(artifact, bundledPluginsDir.getAbsolutePath(), 0, true, Pattern.compile(".*\\.jar"));
            this.log.debug((CharSequence)"Extracted.");
        }
    }

    private Artifact resolveApplicationArtifact(ProductArtifact application) {
        String version;
        if (application.getVersion() != null) {
            version = application.getVersion();
        } else {
            version = this.project.getDependencyManagement().getDependencies().stream().filter(dep -> dep.getArtifactId().equals(application.getArtifactId())).filter(dep -> dep.getGroupId().equals(application.getGroupId())).findFirst().map(Dependency::getVersion).orElse(null);
            if (version != null) {
                this.log.info((CharSequence)("Using dependency management version " + version + " for application " + application.getGroupId() + ":" + application.getArtifactId()));
            }
        }
        Artifact artifact = this.repositorySystem.createArtifact(application.getGroupId(), application.getArtifactId(), version, "compile", "obr");
        ArtifactResolutionResult resolutionResult = this.resolve(artifact);
        if (resolutionResult.isSuccess()) {
            return artifact;
        }
        throw new ArtifactResolutionException(resolutionResult);
    }

    private ArtifactResolutionResult resolve(Artifact artifact) {
        ArtifactResolutionRequest artifactResolutionRequest = new ArtifactResolutionRequest();
        artifactResolutionRequest.setArtifact(artifact);
        MojoExecutor.ExecutionEnvironment executionEnvironment = this.context.getExecutionEnvironment();
        artifactResolutionRequest.setLocalRepository(executionEnvironment.getMavenSession().getLocalRepository());
        artifactResolutionRequest.setRemoteRepositories(executionEnvironment.getMavenProject().getRemoteArtifactRepositories());
        return this.artifactResolver.resolve(artifactResolutionRequest);
    }

    private void addOverrides(File appDir, Product product) throws IOException {
        File srcDir = new File(this.project.getBasedir(), "src/test/resources/" + product.getInstanceId() + "-app");
        if (srcDir.exists() && appDir.exists()) {
            FileUtils.copyDirectory(srcDir, appDir, true);
        }
    }

    @Nonnull
    protected final List<Map<String, String>> mergeSystemProperties(Product product) {
        ArrayList<Map<String, String>> mergedPropertyMaps = new ArrayList<Map<String, String>>();
        int nodeCount = product.getNodes().size();
        for (int i = 0; i < nodeCount; ++i) {
            mergedPropertyMaps.add(this.mergeSystemProperties(product, i));
        }
        return mergedPropertyMaps;
    }

    private Map<String, String> mergeSystemProperties(Product product, int nodeIndex) {
        HashMap<String, String> properties = new HashMap<String, String>(this.getSystemProperties(product, nodeIndex));
        properties.put("jarsToSkip", this.getJarsToSkipWhenScanningForTldsAndWebFragments());
        properties.putAll(product.getSystemPropertiesForNode(nodeIndex));
        Properties userProperties = this.context.getExecutionEnvironment().getMavenSession().getUserProperties();
        userProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> properties.put((String)key, (String)value)));
        return properties;
    }

    private String getJarsToSkipWhenScanningForTldsAndWebFragments() {
        HashSet<String> jarsToSkip = new HashSet<String>();
        jarsToSkip.add("${tomcat.util.scan.StandardJarScanFilter.jarsToSkip}");
        jarsToSkip.addAll(this.getExtraJarsToSkipWhenScanningForTldsAndWebFragments());
        return String.join((CharSequence)",", jarsToSkip);
    }

    @Nonnull
    protected Collection<String> getExtraJarsToSkipWhenScanningForTldsAndWebFragments() {
        return Collections.emptyList();
    }

    @Nonnull
    protected abstract Map<String, String> getSystemProperties(Product var1, int var2);

    @Nonnull
    protected String getLibArtifactTargetDir() {
        return TOMCAT_LIB_DIR;
    }

    protected final void setLatestStableVersion(Product product, ProductArtifact productArtifact) throws MojoExecutionException {
        this.log.info((CharSequence)"determining latest stable product version...");
        Artifact warArtifact = this.repositorySystem.createProjectArtifact(productArtifact.getGroupId(), productArtifact.getArtifactId(), productArtifact.getVersion());
        String stableVersion = product.getArtifactRetriever().getLatestStableVersion(warArtifact);
        this.log.info((CharSequence)("using latest stable product version: " + stableVersion));
        productArtifact.setVersion(stableVersion);
        product.setVersion(stableVersion);
    }

    @Nonnull
    protected final ProductArtifact getArtifact(Product product) {
        ProductArtifact defaultArtifact = this.getArtifact();
        return new ProductArtifact(ProjectUtils.firstNotNull(product.getGroupId(), defaultArtifact.getGroupId()), ProjectUtils.firstNotNull(product.getArtifactId(), defaultArtifact.getArtifactId()), ProjectUtils.firstNotNull(product.getVersion(), defaultArtifact.getVersion()));
    }
}

