/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.pdk;

import com.atlassian.maven.plugins.amps.AbstractProductAwareMojo;
import com.atlassian.maven.plugins.amps.InstallParams;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.upm.signing.tool.SignatureBuilder;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractInstallPluginMojo
extends AbstractProductAwareMojo {
    @Parameter(property="atlassian.plugin.key")
    private String pluginKey;
    @Parameter(property="project.groupId")
    private String groupId;
    @Parameter(property="project.artifactId")
    private String artifactId;
    @Parameter(property="http.port")
    private int httpPort;
    @Parameter(property="http.timeout", defaultValue="5000")
    private int httpTimeout;
    @Parameter(property="context.path")
    private String contextPath;
    @Parameter(property="username", defaultValue="admin")
    private String username;
    @Parameter(property="password", defaultValue="admin")
    private String password;
    @Parameter(property="server", defaultValue="localhost")
    private String server;
    @Parameter(property="signature")
    private String signatureProperty;
    @Parameter(property="signatureFile")
    private String signatureFile;
    @Parameter(property="privateKey")
    private String privateKey;
    @Parameter(property="privateKeyFile")
    private String privateKeyFile;

    protected final void installPlugin(boolean isTestPlugin) throws MojoExecutionException {
        this.ensurePluginKeyExists();
        ProductHandler productHandler = this.getProductHandler(this.getProductId());
        File pluginFile = this.getPluginFile(isTestPlugin);
        String signature = this.getSignature();
        if (signature == null) {
            signature = this.forgeSignature(pluginFile);
        }
        boolean isUsingHttps = this.isUsingHttps();
        InstallParams params = new InstallParams.Builder().pluginFile(pluginFile).pluginKey(this.pluginKey).useHttps(isUsingHttps).server(this.server).port(this.getPort(productHandler)).contextPath(this.getContextPath(productHandler)).username(this.username).password(this.password).signature(signature).connectionTimeout(this.httpTimeout).build();
        this.getPluginInstaller().installPlugin(params);
    }

    private File getPluginFile(boolean isTestPlugin) {
        MavenContext mavenContext = this.getMavenContext();
        StringBuilder sb = new StringBuilder(mavenContext.getBuildDirectory());
        sb.append("/").append(mavenContext.getProject().getBuild().getFinalName());
        if (isTestPlugin) {
            sb.append("-tests");
        }
        sb.append(".jar");
        return new File(sb.toString());
    }

    private String getSignature() throws MojoExecutionException {
        return this.getPropertyValue(this.signatureProperty, "signature", this.signatureFile, "signatureFile").orElse(null);
    }

    private String forgeSignature(File file) throws MojoExecutionException {
        return this.getPropertyValue(this.privateKey, "privateKey", this.privateKeyFile, "privateKeyFile").map(SignatureBuilder::withPrivateKey).map(sb -> sb.forgeSignature(file)).orElse(null);
    }

    private void ensurePluginKeyExists() {
        if (this.pluginKey == null) {
            this.pluginKey = this.groupId + "." + this.artifactId;
        }
    }

    private int getPort(ProductHandler handler) {
        int defaultPort = this.isUsingHttps() ? handler.getDefaultHttpsPort() : handler.getDefaultHttpPort();
        return this.httpPort == 0 ? defaultPort : this.httpPort;
    }

    private boolean isUsingHttps() {
        return this.server != null && this.server.startsWith("https://");
    }

    private String getContextPath(ProductHandler handler) {
        return this.contextPath == null ? "/" + handler.getId() : this.contextPath;
    }
}

