/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.osgi;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoFailureException;

public final class ValidateManifestEntries {
    private ValidateManifestEntries() {
    }

    public static void validate(String actualImports, String expectedImports) throws MojoFailureException {
        Parameters expected = new Parameters(expectedImports);
        Parameters actual = new Parameters(actualImports);
        ImportError importError = ValidateManifestEntries.validateImports(expected, actual);
        if (importError.isFound()) {
            throw new MojoFailureException(importError.toString());
        }
    }

    private static ImportError validateImports(Parameters expected, Parameters actual) {
        Stream<ImportError> unexpectedImports;
        Stream<ImportError> importMismatches = expected.entrySet().stream().map(entry -> ValidateManifestEntries.validateImport((String)entry.getKey(), (Attrs)entry.getValue(), actual));
        List<ImportError> collect = Stream.concat(importMismatches, unexpectedImports = actual.keySet().stream().map(packageName -> ValidateManifestEntries.findUnexpectedImport(packageName, expected))).filter(ImportError::isFound).collect(Collectors.toList());
        return collect.isEmpty() ? ImportError.empty() : ImportError.with("Manifest imports contain mismatches:", collect);
    }

    private static ImportError validateImport(String packageName, Attrs expected, Parameters actual) {
        Attrs actualAttrs = actual.get(packageName);
        if (actualAttrs == null) {
            return ImportError.with("Missing import: '" + packageName + "'");
        }
        List<ImportError> attrMismatches = ValidateManifestEntries.findAttrMismatches(expected, actualAttrs);
        return attrMismatches.isEmpty() ? ImportError.empty() : ImportError.with("Import '" + packageName + "' has mismatched attributes:", attrMismatches);
    }

    private static ImportError findUnexpectedImport(String packageName, Parameters expected) {
        if (!expected.containsKey(packageName)) {
            return ImportError.with("Unexpected import: '" + packageName + "'");
        }
        return ImportError.empty();
    }

    private static List<ImportError> findAttrMismatches(Attrs expected, Attrs actualAttrs) {
        Stream<ImportError> paramMismatches = expected.entrySet().stream().map(entry -> ValidateManifestEntries.validateAttrs((String)entry.getKey(), (String)entry.getValue(), actualAttrs));
        Stream<ImportError> unexpectedParams = actualAttrs.keySet().stream().map(attr -> ValidateManifestEntries.findUnexpectedAttr(attr, expected));
        return Stream.concat(paramMismatches, unexpectedParams).filter(ImportError::isFound).collect(Collectors.toList());
    }

    private static ImportError validateAttrs(String key, String value, Attrs actual) {
        String actualValue = actual.get(key);
        if (actualValue == null) {
            return ImportError.with("Missing attribute: '" + key + "'");
        }
        if (!value.equals(actualValue)) {
            return ImportError.with("Attribute '" + key + "' has value '" + actualValue + "' instead of '" + value + "'");
        }
        return ImportError.empty();
    }

    private static ImportError findUnexpectedAttr(String key, Attrs expected) {
        if (!expected.containsKey(key)) {
            return ImportError.with("Unexpected attribute: '" + key + "'");
        }
        return ImportError.empty();
    }

    private static class ImportError {
        private final String message;
        private final List<ImportError> details;

        public ImportError(String message, List<ImportError> details) {
            this.message = message;
            this.details = details;
        }

        public boolean isEmpty() {
            return this.message == null && this.details.isEmpty();
        }

        public boolean isFound() {
            return !this.isEmpty();
        }

        public static ImportError empty() {
            return new ImportError(null, Collections.emptyList());
        }

        public static ImportError with(String message) {
            return new ImportError(message, new ArrayList<ImportError>());
        }

        public static ImportError with(String message, List<ImportError> deeper) {
            return new ImportError(message, deeper);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.parseError(0, sb);
            return sb.toString();
        }

        private void parseError(int indentLevel, StringBuilder sb) {
            for (int i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append(this.message);
            sb.append("\n");
            for (ImportError error : this.details) {
                error.parseError(indentLevel + 1, sb);
            }
        }
    }
}

