/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.Product;
import java.util.Optional;

public enum PlatformVersion {
    PLATFORM_8(8),
    BEFORE_PLATFORM_8(0);

    private final int version;

    private PlatformVersion(int version) {
        this.version = version;
    }

    public static Optional<PlatformVersion> fromProduct(Product product) {
        String resolvedVersion = product.getResolvedVersion();
        String productId = product.getId();
        if (resolvedVersion == null) {
            return Optional.empty();
        }
        try {
            int majorVersion = Integer.parseInt(resolvedVersion.split("\\.")[0]);
            if (productId.equals("bamboo") && majorVersion <= 11 || productId.equals("bitbucket") && majorVersion <= 9 || productId.equals("confluence") && majorVersion <= 9 || productId.equals("crowd") && majorVersion <= 6 || productId.equals("jira") && majorVersion <= 10 || productId.equals("refapp") && majorVersion <= 7) {
                return Optional.of(BEFORE_PLATFORM_8);
            }
            return Optional.of(PLATFORM_8);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public boolean isProductVersionThisOrHigher(Product product) {
        return PlatformVersion.fromProduct(product).map(productPlatformVersion -> productPlatformVersion.version >= this.version).orElse(false);
    }
}

