/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.signing.tool;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum AtlassianCertificate {
    MARKETPLACE_STAGING_ROOT("atlassian_root_ca_dev.crt", AtlassianCertificate.format("MIIBnDCCAU6gAwIBAgIUGWTSI/lut+zq+QmllNkk9lUPGMMwBQYDK2VwMEIxEjAQ\nBgNVBAoMCUF0bGFzc2lhbjEsMCoGA1UEAwwjTWFya2V0cGxhY2UgUm9vdCBDQSBE\nRVYgTk9fUFJPRF9VU0UwHhcNMjQxMjMxMDAwMDAwWhcNMzQwMTAxMDAwMDAwWjBC\nMRIwEAYDVQQKDAlBdGxhc3NpYW4xLDAqBgNVBAMMI01hcmtldHBsYWNlIFJvb3Qg\nQ0EgREVWIE5PX1BST0RfVVNFMCowBQYDK2VwAyEAytpq5o0VNz7m5V6WmnYOmA2A\nhv97ZT4ehyq+jj3JXYyjVjBUMB0GA1UdDgQWBBTXvQ2iia/yMuQT6fRil6waeK/n\nwzAfBgNVHSMEGDAWgBTXvQ2iia/yMuQT6fRil6waeK/nwzASBgNVHRMBAf8ECDAG\nAQH/AgEBMAUGAytlcANBAB1JFxLECj0/mYOCKGDrntB729YPiLMbbOZA2/B7YCDj\nDX+/6/a9d525JNECsz5NDldO22NpTlOGIPl9Bxr1SwE=\n")),
    MARKETPLACE_STAGING_INTERMEDIATE("atlassian_intermediate_ca_dev.crt", AtlassianCertificate.format("MIIBpDCCAVagAwIBAgIUQGmDe6BdO1s38F6hZqWxjEVrKmwwBQYDK2VwMEIxEjAQ\nBgNVBAoMCUF0bGFzc2lhbjEsMCoGA1UEAwwjTWFya2V0cGxhY2UgUm9vdCBDQSBE\nRVYgTk9fUFJPRF9VU0UwHhcNMjQxMjMxMDAwMDAwWhcNMzQwMTAxMDAwMDAwWjBK\nMRIwEAYDVQQKDAlBdGxhc3NpYW4xNDAyBgNVBAMMK01hcmtldHBsYWNlIEludGVy\nbWVkaWF0ZSBDQSBERVYgTk9fUFJPRF9VU0UwKjAFBgMrZXADIQBS00EuKBaL8be7\n0ioYMWeP00WsKr0BIRxJkMOC01SUxaNWMFQwHQYDVR0OBBYEFDzFXV1T1MtrwTaF\nZKlhp92qViPXMB8GA1UdIwQYMBaAFNe9DaKJr/Iy5BPp9GKXrBp4r+fDMBIGA1Ud\nEwEB/wQIMAYBAf8CAQAwBQYDK2VwA0EA3cQgpQCwdwOXc9x1spOv8Ksic+Tt6Fi3\nYmppJy5sgrIs6gg3y+JJVv6miZW6sRe0ce7X6KJzHoUtHIVa5Q5/Dg==\n")),
    MARKETPLACE_ROOT_V1("atlassian_root_ca.crt", AtlassianCertificate.format("MIIBiDCCATqgAwIBAgIUYRpJO0DR/qqKlSw6SOAl3C5iPcswBQYDK2VwMDgxEjAQ\nBgNVBAoMCUF0bGFzc2lhbjEiMCAGA1UEAwwZTWFya2V0cGxhY2UgQVMgUm9vdCBD\nQSB2MTAeFw0yNDEyMzEwMDAwMDBaFw0zNDAxMDEwMDAwMDBaMDgxEjAQBgNVBAoM\nCUF0bGFzc2lhbjEiMCAGA1UEAwwZTWFya2V0cGxhY2UgQVMgUm9vdCBDQSB2MTAq\nMAUGAytlcAMhAK3EQa3ZukwKrUcMmp210dN+x6pwF6qzVHiNi/EB1jUTo1YwVDAd\nBgNVHQ4EFgQU7hrebw3cARlhhkaxF8mN03PbMOowHwYDVR0jBBgwFoAU7hrebw3c\nARlhhkaxF8mN03PbMOowEgYDVR0TAQH/BAgwBgEB/wIBATAFBgMrZXADQQAx0Uvv\n0seDT1ncRodzIOFG5n9PdNCc51zGtNkQL4IUidgHRiA7/yAg9hCYkM9AFOUMJHLJ\nMCjxSPSro6vKDtgP\n")),
    MARKETPLACE_INTERMEDIATE_V1("atlassian_intermediate_ca.crt", AtlassianCertificate.format("MIIBkDCCAUKgAwIBAgIUeN3VUUZtMDpOMj4/53HYAEg7fe8wBQYDK2VwMDgxEjAQ\nBgNVBAoMCUF0bGFzc2lhbjEiMCAGA1UEAwwZTWFya2V0cGxhY2UgQVMgUm9vdCBD\nQSB2MTAeFw0yNDEyMzEwMDAwMDBaFw0yNzAxMTAwMDAwMDBaMEAxEjAQBgNVBAoM\nCUF0bGFzc2lhbjEqMCgGA1UEAwwhTWFya2V0cGxhY2UgQVMgSW50ZXJtZWRpYXRl\nIENBIHYxMCowBQYDK2VwAyEAJMOA3thx/gEukg1W/Mvi0buKyWW9VUZk5CR1n3W9\nhT6jVjBUMB0GA1UdDgQWBBS9amfvKQ0bdj8sD9pzs6+jwTkYfDAfBgNVHSMEGDAW\ngBTuGt5vDdwBGWGGRrEXyY3Tc9sw6jASBgNVHRMBAf8ECDAGAQH/AgEAMAUGAytl\ncANBABqdcd+nGTO+2spHj77Gvn6O5qdDSniwKegNNNsH6HKCNlvZVEomEagf0jmT\n7/D9KijNXJTgdkhDIyQaW2H3eA0=\n"));

    private final String filename;
    private final String certificate;

    private static String format(String certificate) {
        return "-----BEGIN CERTIFICATE-----\n" + certificate + "-----END CERTIFICATE-----\n";
    }

    private AtlassianCertificate(String filename, String certificate) {
        this.filename = filename;
        this.certificate = certificate;
    }

    public String getFileName() {
        return this.filename;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public static Set<AtlassianCertificate> getCertificates(String selector) {
        if (selector == null) {
            return EnumSet.noneOf(AtlassianCertificate.class);
        }
        switch (selector.toUpperCase()) {
            case "ALL": {
                return Collections.unmodifiableSet(EnumSet.allOf(AtlassianCertificate.class));
            }
            case "PROD": {
                return Collections.unmodifiableSet(EnumSet.of(MARKETPLACE_ROOT_V1, MARKETPLACE_INTERMEDIATE_V1));
            }
            case "STAGING": {
                return Collections.unmodifiableSet(EnumSet.of(MARKETPLACE_STAGING_ROOT, MARKETPLACE_STAGING_INTERMEDIATE));
            }
        }
        return EnumSet.noneOf(AtlassianCertificate.class);
    }
}

