/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.plugins.codegen.PluginProjectChange;
import com.atlassian.plugins.codegen.SummarizeAsGroup;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class BundleInstruction
implements PluginProjectChange,
SummarizeAsGroup {
    private final Category category;
    private final String packageName;
    private final String version;
    private final boolean optional;

    public static BundleInstruction importPackage(String packageName) {
        return new BundleInstruction(Category.IMPORT, packageName);
    }

    public static BundleInstruction importPackage(String packageName, String version) {
        return new BundleInstruction(Category.IMPORT, packageName, version);
    }

    public static BundleInstruction importPackageOptional(String packageName) {
        return new BundleInstruction(Category.IMPORT, packageName, true);
    }

    public static BundleInstruction importPackageOptional(String packageName, String version) {
        return new BundleInstruction(Category.IMPORT, packageName, version, true);
    }

    public static BundleInstruction exportPackage(String packageName) {
        return new BundleInstruction(Category.EXPORT, packageName);
    }

    public static BundleInstruction exportPackage(String packageName, String version) {
        return new BundleInstruction(Category.EXPORT, packageName, version);
    }

    public static BundleInstruction dynamicImportPackage(String packageName, String version) {
        return new BundleInstruction(Category.DYNAMIC_IMPORT, packageName, version);
    }

    public static BundleInstruction privatePackage(String packageName) {
        return new BundleInstruction(Category.PRIVATE, packageName);
    }

    public BundleInstruction(Category category, String packageName, String version, boolean optional) {
        this.category = Objects.requireNonNull(category, "category");
        this.packageName = Objects.requireNonNull(packageName, "packageName");
        this.version = version;
        this.optional = optional;
    }

    public BundleInstruction(Category category, String packageName, String version) {
        this(category, packageName, version, false);
    }

    public BundleInstruction(Category category, String packageName, boolean optional) {
        this(category, packageName, null, optional);
    }

    public BundleInstruction(Category category, String packageName) {
        this(category, packageName, null, false);
    }

    public Category getCategory() {
        return this.category;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getVersion() {
        return this.version;
    }

    public BundleInstruction dropVersion() {
        return new BundleInstruction(this.category, this.packageName, null, this.optional);
    }

    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public String getGroupName() {
        return "bundle instructions";
    }

    public String toInstructionLine() {
        StringBuilder sb = new StringBuilder(this.getPackageName());
        Optional.ofNullable(this.getVersion()).ifPresent(version -> sb.append(";version=\"").append((String)version).append("\""));
        if (this.isOptional()) {
            sb.append(";resolution:=optional");
        }
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.packageName, this.version, this.optional});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BundleInstruction other = (BundleInstruction)obj;
        return Objects.equals((Object)this.category, (Object)other.category) && Objects.equals(this.packageName, other.packageName) && Objects.equals(this.version, other.version) && this.optional == other.optional;
    }

    public boolean equalsCategoryAndPackageName(BundleInstruction other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return Objects.equals((Object)this.category, (Object)other.category) && Objects.equals(this.packageName, other.packageName);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("category", (Object)this.category).append("packageName", (Object)this.packageName).append("version", (Object)this.version).append("optional", this.optional).toString();
    }

    public static enum Category {
        IMPORT("Import-Package"),
        EXPORT("Export-Package"),
        PRIVATE("Private-Package"),
        DYNAMIC_IMPORT("DynamicImport-Package");

        private final String elementName;

        private Category(String elementName) {
            this.elementName = elementName;
        }

        public String getElementName() {
            return this.elementName;
        }

        public static Optional<Category> fromElementName(String elementName) {
            return Arrays.stream(Category.values()).filter(category -> category.getElementName().equals(elementName)).findFirst();
        }
    }
}

