/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.jira.util;

import com.atlassian.administration.quicksearch.util.VersionVerifier;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class SelfDisabler
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SelfDisabler.class);
    private static final String PLUGIN_KEY = "com.atlassian.administration.atlassian-admin-quicksearch-jira";
    private final PluginController pluginController;
    private final VersionVerifier versionVerifier;
    private final EventPublisher eventPublisher;

    public SelfDisabler(EventPublisher eventPublisher, PluginController pluginController, VersionVerifier versionVerifier) {
        this.eventPublisher = eventPublisher;
        this.pluginController = pluginController;
        this.versionVerifier = versionVerifier;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.isBelowMinRequireVersion()) {
            this.eventPublisher.register((Object)this);
        }
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent pluginEnabledEvent) {
        if (pluginEnabledEvent.getPlugin().getKey().equals(PLUGIN_KEY)) {
            log.warn("Disabling the '%s' plugin, it should not run in JIRA with version below 6.0");
            this.pluginController.disablePlugin(PLUGIN_KEY);
        }
    }

    private boolean isBelowMinRequireVersion() {
        return this.versionVerifier.isLessThan(6, 0);
    }
}

