/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.jira.spi;

import com.atlassian.administration.quicksearch.impl.spi.SectionKeys;
import com.atlassian.administration.quicksearch.jira.spi.AbstractJiraAdminWebItem;
import com.atlassian.administration.quicksearch.jira.spi.JiraAdminLink;
import com.atlassian.administration.quicksearch.jira.spi.JiraContextHelper;
import com.atlassian.administration.quicksearch.jira.spi.SimpleLinkProvider;
import com.atlassian.administration.quicksearch.spi.AdminLink;
import com.atlassian.administration.quicksearch.spi.AdminLinkSection;
import com.atlassian.administration.quicksearch.spi.UserContext;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JiraAdminLinkSection
extends AbstractJiraAdminWebItem
implements AdminLinkSection {
    private final SimpleLinkProvider simpleLinkProvider;
    private final UserContext userContext;
    private final String parentSectionKey;
    private final JiraContextHelper contextHelper;
    private Iterable<AdminLinkSection> sections;
    private Iterable<AdminLink> links;

    public JiraAdminLinkSection(SimpleLinkSection item, SimpleLinkProvider simpleLinkProvider, UserContext userContext, JiraContextHelper contextHelper) {
        this(item, simpleLinkProvider, userContext, contextHelper, null);
    }

    public JiraAdminLinkSection(SimpleLinkSection item, SimpleLinkProvider simpleLinkProvider, UserContext userContext, JiraContextHelper helper, @Nullable String parentSectionKey) {
        super(item);
        this.simpleLinkProvider = (SimpleLinkProvider)Preconditions.checkNotNull((Object)simpleLinkProvider, (Object)"simpleLinkProvider");
        this.userContext = (UserContext)Preconditions.checkNotNull((Object)userContext, (Object)"userContext");
        this.parentSectionKey = parentSectionKey;
        this.contextHelper = helper;
    }

    @Override
    public String getLocation() {
        return this.parentSectionKey;
    }

    @Override
    @Nonnull
    public Iterable<AdminLinkSection> getSections() {
        if (this.sections == null) {
            this.sections = ImmutableList.copyOf((Iterable)Iterables.transform(this.simpleLinkProvider.getSectionsForLocation(this.getId(), this.contextHelper.getUser(), this.contextHelper.getJiraHelper()), this.toChildSection()));
        }
        return this.sections;
    }

    @Override
    @Nonnull
    public Iterable<AdminLink> getLinks() {
        if (this.links == null) {
            this.links = ImmutableList.copyOf((Iterable)Iterables.transform(this.simpleLinkProvider.getLinksForSection(SectionKeys.fullSectionKey(this), this.contextHelper.getUser(), this.contextHelper.getJiraHelper()), this.toChildLink()));
        }
        return this.links;
    }

    private Function<SimpleLinkSection, AdminLinkSection> toChildSection() {
        return new Function<SimpleLinkSection, AdminLinkSection>(){

            public AdminLinkSection apply(SimpleLinkSection section) {
                return new JiraAdminLinkSection(section, JiraAdminLinkSection.this.simpleLinkProvider, JiraAdminLinkSection.this.userContext, JiraAdminLinkSection.this.contextHelper, JiraAdminLinkSection.this.getId());
            }
        };
    }

    private Function<SimpleLink, AdminLink> toChildLink() {
        return new Function<SimpleLink, AdminLink>(){

            public AdminLink apply(SimpleLink link) {
                return new JiraAdminLink(link);
            }
        };
    }
}

