/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.impl.spi.alias;

import com.atlassian.administration.quicksearch.spi.UserContext;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class StaticAliasProviderHelper {
    private static final String KEYWORDS_SEPARATOR = ",";
    public static final Set<String> EMPTY_KEYWORDS = Collections.emptySet();
    private static final String I18N = "i18n";
    private final LoadingCache<CacheKey, Set<String>> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<CacheKey, Set<String>>(){

        public Set<String> load(CacheKey key) throws Exception {
            return StaticAliasProviderHelper.this.loadAliases(key);
        }
    });

    public Set<String> aliasesFor(String key, UserContext context) {
        CacheKey cacheKey = new CacheKey(key, context);
        return (Set)this.cache.getUnchecked((Object)cacheKey);
    }

    private Set<String> loadAliases(CacheKey cacheKey) {
        String keywords = cacheKey.getUserContext().getI18nResolver().getText(cacheKey.key);
        if (StringUtils.isEmpty(keywords) || keywords.equals(cacheKey.key)) {
            return EMPTY_KEYWORDS;
        }
        return this.splitAliases(keywords);
    }

    private Set<String> splitAliases(String keywords) {
        String[] split = keywords.split(KEYWORDS_SEPARATOR);
        return ImmutableSortedSet.copyOf(Arrays.asList(split));
    }

    public void resetCache() {
        this.cache.invalidateAll();
    }

    @PluginEventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent pluginModuleEnabledEvent) {
        this.onPluginModuleEvent(pluginModuleEnabledEvent.getModule());
    }

    @PluginEventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent pluginModuleDisabledEvent) {
        this.onPluginModuleEvent(pluginModuleDisabledEvent.getModule());
    }

    private void onPluginModuleEvent(ModuleDescriptor<?> module) {
        if (this.isI18nAffecting(module)) {
            this.resetCache();
        }
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent pluginEnabledEvent) {
        this.onPluginEvent(pluginEnabledEvent.getPlugin());
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent pluginDisabledEvent) {
        this.onPluginEvent(pluginDisabledEvent.getPlugin());
    }

    private void onPluginEvent(Plugin plugin) {
        if (this.isI18nAffecting(plugin)) {
            this.resetCache();
        }
    }

    protected boolean isI18nAffecting(Plugin changedPlugin) {
        return Iterables.any((Iterable)changedPlugin.getResourceDescriptors(), (Predicate)new Resources.TypeFilter(I18N));
    }

    protected boolean isI18nAffecting(ModuleDescriptor<?> moduleDescriptor) {
        return Iterables.any((Iterable)moduleDescriptor.getResourceDescriptors(), (Predicate)new Resources.TypeFilter(I18N));
    }

    private static final class CacheKey {
        private final String key;
        private final Locale locale;
        private final int hashCode;
        private final UserContext userContext;

        public CacheKey(String key, UserContext userContext) {
            this.key = key;
            this.locale = userContext.getLocale();
            this.userContext = userContext;
            this.hashCode = 37 * key.hashCode() + this.locale.hashCode();
        }

        public UserContext getUserContext() {
            return this.userContext;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return new EqualsBuilder().append(this.key, that.key).append(this.locale, that.locale).isEquals();
        }
    }
}

