/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.rest;

import com.atlassian.administration.quicksearch.rest.LinkBean;
import com.atlassian.administration.quicksearch.rest.LocationBean;
import com.atlassian.administration.quicksearch.rest.SectionBean;
import com.atlassian.administration.quicksearch.spi.AdminLink;
import com.atlassian.administration.quicksearch.spi.AdminLinkAliasProvider;
import com.atlassian.administration.quicksearch.spi.AdminLinkManager;
import com.atlassian.administration.quicksearch.spi.AdminLinkSection;
import com.atlassian.administration.quicksearch.spi.UserContext;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class AbstractAdminLinkResource {
    protected final AdminLinkManager linkManager;
    protected final AdminLinkAliasProvider aliasProvider;

    protected AbstractAdminLinkResource(AdminLinkManager linkManager, AdminLinkAliasProvider aliasProvider) {
        this.linkManager = linkManager;
        this.aliasProvider = aliasProvider;
    }

    protected final LocationBean getLinksFor(String location, UserContext userContext) {
        return this.getLinksFor(location, userContext, true);
    }

    protected final LocationBean getLinksFor(String location, UserContext userContext, boolean stripRootSections) {
        return this.getLinksFor(Collections.singletonList(location), userContext, stripRootSections);
    }

    protected final LocationBean getLinksFor(Iterable<String> locations, UserContext userContext) {
        return this.getLinksFor(locations, userContext, true);
    }

    protected final LocationBean getLinksFor(Iterable<String> locations, final UserContext userContext, boolean stripRootSections) {
        ImmutableList rootSections = ImmutableList.copyOf((Iterable)Iterables.transform(locations, (Function)new Function<String, AdminLinkSection>(){

            public AdminLinkSection apply(String location) {
                return AbstractAdminLinkResource.this.linkManager.getSection(location, userContext);
            }
        }));
        if (stripRootSections) {
            return this.toLocationBean((Iterable<AdminLinkSection>)rootSections, userContext);
        }
        final HashMap currentLinks = Maps.newHashMap();
        ImmutableList convertedSections = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)rootSections, (Function)new Function<AdminLinkSection, SectionBean>(){

            public SectionBean apply(@Nullable AdminLinkSection section) {
                return AbstractAdminLinkResource.this.toSectionBean(section, Collections.emptyList(), userContext, currentLinks);
            }
        }));
        return new LocationBean(null, Collections.<LinkBean>emptyList(), (List<SectionBean>)convertedSections);
    }

    private LocationBean toLocationBean(Iterable<AdminLinkSection> rootSections, UserContext userContext) {
        return this.toSectionBean(rootSections, Collections.<AdminLinkSection>emptyList(), userContext);
    }

    private SectionBean toSectionBean(Iterable<AdminLinkSection> sections, Iterable<AdminLinkSection> parentSections, UserContext context) {
        ArrayList sectionBeans = Lists.newArrayList();
        HashMap currentLinks = Maps.newHashMap();
        for (AdminLinkSection section : sections) {
            sectionBeans.add(this.toSectionBean(section, parentSections, context, currentLinks));
        }
        ArrayList allSections = Lists.newArrayList();
        ArrayList allLinks = Lists.newArrayList();
        for (SectionBean directChild : sectionBeans) {
            allSections.addAll(directChild.sections());
            allLinks.addAll(directChild.links());
        }
        String key = sectionBeans.size() == 1 ? ((SectionBean)sectionBeans.get(0)).key() : null;
        String label = sectionBeans.size() == 1 ? ((SectionBean)sectionBeans.get(0)).label() : null;
        String location = sectionBeans.size() == 1 ? ((SectionBean)sectionBeans.get(0)).location() : null;
        return new SectionBean(key, location, label, allSections, allLinks);
    }

    private SectionBean toSectionBean(AdminLinkSection section, Iterable<AdminLinkSection> parentSections, final UserContext context, final Map<String, LinkBean> currentLinks) {
        final Iterable fullParents = Iterables.concat(parentSections, (Iterable)ImmutableList.of((Object)section));
        ImmutableList.Builder childSections = ImmutableList.builder();
        List<LinkBean> links = this.transformAndCopy(section.getLinks(), new Function<AdminLink, LinkBean>(){

            public LinkBean apply(AdminLink link) {
                if (currentLinks.containsKey(link.getLinkUrl())) {
                    LinkBean existing = (LinkBean)currentLinks.get(link.getLinkUrl());
                    existing.aliases = ImmutableSortedSet.naturalOrder().addAll(existing.aliases).add((Object)link.getLabel()).addAll((Iterable)AbstractAdminLinkResource.this.aliasProvider.getAliases(link, fullParents, context)).build();
                    return null;
                }
                LinkBean newLink = new LinkBean(link.getId(), link.getLinkUrl(), link.getLabel(), AbstractAdminLinkResource.this.aliasProvider.getAliases(link, fullParents, context));
                currentLinks.put(newLink.linkUrl, newLink);
                return newLink;
            }
        });
        for (AdminLinkSection childSection : section.getSections()) {
            childSections.add((Object)this.toSectionBean(childSection, fullParents, context, currentLinks));
        }
        return new SectionBean(section.getId(), section.getLabel(), section.getLocation(), (List<SectionBean>)childSections.build(), links);
    }

    private <I, O> List<O> transformAndCopy(Iterable<I> input, Function<I, O> transformer) {
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(input, transformer), (Predicate)Predicates.notNull()));
    }
}

