/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.impl.spi;

import com.atlassian.administration.quicksearch.spi.UserContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

public class DefaultUserContext
implements UserContext {
    private final String username;
    private final Locale locale;
    private final I18nResolver resolver;
    private final HttpServletRequest request;
    private final Map<String, Object> context;

    public static UserContext unauthenticated(HttpServletRequest request) {
        return new DefaultUserContext(null, null, null, request);
    }

    public DefaultUserContext(String username, Locale locale, I18nResolver resolver, HttpServletRequest request, Map<String, Object> context) {
        this.username = username;
        this.locale = (Locale)Preconditions.checkNotNull((Object)locale, (Object)"locale");
        this.resolver = (I18nResolver)Preconditions.checkNotNull((Object)resolver, (Object)"resolver");
        this.request = (HttpServletRequest)Preconditions.checkNotNull((Object)request, (Object)"request");
        this.context = (Map)Preconditions.checkNotNull(context, (Object)"context");
    }

    public DefaultUserContext(String username, Locale locale, I18nResolver resolver, HttpServletRequest request) {
        this(username, locale, resolver, request, Collections.emptyMap());
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAuthenticated() {
        return this.username != null;
    }

    @Nonnull
    public Locale getLocale() {
        return this.locale;
    }

    @Nonnull
    public I18nResolver getI18nResolver() {
        return this.resolver;
    }

    @Nonnull
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Nonnull
    public Map<String, Object> getContextMap() {
        return this.context;
    }
}

