/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.util;

import com.atlassian.adf.model.mark.DataConsumer;
import com.atlassian.adf.model.mark.Fragment;
import com.atlassian.adf.model.mark.Link;
import com.atlassian.adf.model.node.BlockCard;
import com.atlassian.adf.model.node.Blockquote;
import com.atlassian.adf.model.node.BodiedExtension;
import com.atlassian.adf.model.node.BulletList;
import com.atlassian.adf.model.node.CodeBlock;
import com.atlassian.adf.model.node.Date;
import com.atlassian.adf.model.node.DecisionItem;
import com.atlassian.adf.model.node.DecisionList;
import com.atlassian.adf.model.node.Doc;
import com.atlassian.adf.model.node.EmbedCard;
import com.atlassian.adf.model.node.Emoji;
import com.atlassian.adf.model.node.Expand;
import com.atlassian.adf.model.node.Extension;
import com.atlassian.adf.model.node.HardBreak;
import com.atlassian.adf.model.node.Heading;
import com.atlassian.adf.model.node.InlineCard;
import com.atlassian.adf.model.node.InlineExtension;
import com.atlassian.adf.model.node.ListItem;
import com.atlassian.adf.model.node.Media;
import com.atlassian.adf.model.node.MediaGroup;
import com.atlassian.adf.model.node.MediaInline;
import com.atlassian.adf.model.node.MediaSingle;
import com.atlassian.adf.model.node.Mention;
import com.atlassian.adf.model.node.NestedExpand;
import com.atlassian.adf.model.node.OrderedList;
import com.atlassian.adf.model.node.Panel;
import com.atlassian.adf.model.node.Paragraph;
import com.atlassian.adf.model.node.RichMedia;
import com.atlassian.adf.model.node.Rule;
import com.atlassian.adf.model.node.Status;
import com.atlassian.adf.model.node.Table;
import com.atlassian.adf.model.node.TableCell;
import com.atlassian.adf.model.node.TableHeader;
import com.atlassian.adf.model.node.TableRow;
import com.atlassian.adf.model.node.TaskItem;
import com.atlassian.adf.model.node.TaskList;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.model.node.type.BlockquoteContent;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.model.node.type.ListItemContent;
import com.atlassian.adf.model.node.type.NestedExpandContent;
import com.atlassian.adf.model.node.type.PanelContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.model.node.type.TaskListContent;
import com.atlassian.adf.util.FieldMap;
import java.awt.Color;

public class ExampleAdf {
    private final Doc adf = Doc.doc();

    private ExampleAdf() {
        this.addBlockCards();
        this.addBlockquotes();
        this.addBulletListsAndOrderedLists();
        this.addCitations();
        this.addCodeBlocks();
        this.addDates();
        this.addDecisionLists();
        this.addEmbedCards();
        this.addEmojis();
        this.addExpands();
        this.addHardBreaks();
        this.addHeadings();
        this.addInlineCards();
        this.addMediaGroups();
        this.addMediaInlines();
        this.addMediaSingles();
        this.addMentions();
        this.addParagraphs();
        this.addPanels();
        this.addRules();
        this.addStatuses();
        this.addTables();
        this.addTaskLists();
        this.addTexts();
        this.addUnknowns();
    }

    public static Doc exampleAdf() {
        return new ExampleAdf().adf;
    }

    private void add(DocContent content) {
        this.adf.content(content);
    }

    private void add(DocContent ... content) {
        this.adf.content(content);
    }

    private void addBlockCards() {
        this.add(BlockCard.blockCard().url("http://example.com"), BlockCard.blockCard().data(FieldMap.map("url", "http://example.com")), BlockCard.blockCard().data(FieldMap.map("foo", "bar")), ((BlockCard.Partial.NeedsDatasourceId)BlockCard.blockCard().datasource().url("http://example.com")).id("foo").parameters(FieldMap.map()).views(BlockCard.View.view("table")), BlockCard.blockCard().datasource().id("bar").parameters(FieldMap.map()).views(BlockCard.View.view("table")));
    }

    private void addBlockquotes() {
        this.add(Blockquote.bq("hello", "world"), Blockquote.bq(Paragraph.p("x"), OrderedList.ol(ListItem.li("foo"), ListItem.li("bar")), BulletList.ul(ListItem.li("xyzzy"))), Blockquote.bq((BlockquoteContent)((Extension)Extension.extension().extensionKey("extension-key").extensionType("extension-type").mark(Fragment.fragment("local-id"))).mark(DataConsumer.dataConsumer("source1", "source2"))));
    }

    private void addBulletListsAndOrderedLists() {
        this.add(BulletList.ul(ListItem.li(Paragraph.p("x"), BulletList.ul(ListItem.li("x")), OrderedList.ol(ListItem.li((ListItemContent)Paragraph.p())), CodeBlock.codeBlock("x()"), (ListItemContent)((Extension)Extension.extension().extensionKey("extension-key").extensionType("extension-type").mark(Fragment.fragment("local-id"))).mark(DataConsumer.dataConsumer("source1", "source2")), MediaSingle.mediaSingle().media(Media.fileMedia("id")))), OrderedList.ol(3, ListItem.li("3"), ListItem.li("4")));
    }

    private void addCitations() {
        this.add((DocContent)Paragraph.p((InlineContent)Text.text("\u2014 This is a citation").em()));
    }

    private void addCodeBlocks() {
        this.add(CodeBlock.codeBlock("foo()", "foo {code} bar", "foo {noformat} bar"), CodeBlock.codeBlock("foo()", "foo {code} bar", "foo {noformat} bar").language("java"));
    }

    private void addDates() {
        this.add((DocContent)Paragraph.p((InlineContent)Date.date(818035920000L)));
    }

    private void addDecisionLists() {
        this.add((DocContent)((Object)DecisionList.decisionList("dl1").content(DecisionItem.decisionItem().localId("di1").state("DECIDED"))));
    }

    private void addEmbedCards() {
        this.add((DocContent)EmbedCard.embedCard().layout(RichMedia.Layout.WRAP_LEFT).url("http://example.com"));
    }

    private void addEmojis() {
        this.add((DocContent)Paragraph.p(Emoji.Standard.wink(), Emoji.Standard.flagOn()));
    }

    private void addExpands() {
        this.add((DocContent)Expand.expand(Heading.h1("Hello"), Paragraph.p("world")));
    }

    private void addHardBreaks() {
        this.add((DocContent)Paragraph.p(Text.text("Hello"), HardBreak.br(), Text.text("there"), HardBreak.hardBreakWithText(), HardBreak.br(), Text.text("world")));
    }

    private void addHeadings() {
        this.add((DocContent)Heading.h3("foo"));
    }

    private void addInlineCards() {
        this.add((DocContent)Paragraph.p(InlineCard.inlineCard().url("http://example.com"), InlineCard.inlineCard().url("http://jira.atlassian.com/browse/FOO-1"), InlineCard.inlineCard().url("http://jira.atlassian.com/browse/FOO-1#icft=FOO-1"), InlineCard.inlineCard().url("#icft="), InlineCard.inlineCard().url("#icft=X-1"), InlineCard.inlineCard().url("#icft=FOO-1"), InlineCard.inlineCard().url("#icft=FOO-7"), InlineCard.inlineCard().data(FieldMap.map("url", "http://example.com")), InlineCard.inlineCard().data(FieldMap.map("foo", "bar"))));
    }

    private void addMediaGroups() {
        this.add((DocContent)MediaGroup.mediaGroup(new Media[]{Media.fileMedia("original3"), Media.linkMedia("link").link("http://example.com")}));
    }

    private void addMediaInlines() {
        this.add((DocContent)Paragraph.p(MediaInline.mediaInline("original1").file(), HardBreak.br(), MediaInline.mediaInline("id").link().linkMark("http://example.com"), HardBreak.br(), MediaInline.mediaInline("id2").image().border(2, "#FF5630")));
    }

    private void addMediaSingles() {
        this.add(MediaSingle.mediaSingle().media(Media.fileMedia("id")).width(50), MediaSingle.mediaSingle().media((Media)Media.linkMedia("original1").link(Link.link("http://example.com"))).alignEnd().caption("Hello, world"), MediaSingle.mediaSingle().wrapLeft().media(Media.fileMedia("original2")), MediaSingle.mediaSingle().wrapRight().media(Media.externalMedia("http://www.example.com")));
    }

    private void addMentions() {
        this.add((DocContent)Paragraph.p(Text.text("foo "), Mention.mention("here").text("@here"), Mention.mention("all").text("@all"), Mention.mention("UNKNOWN_USER"), Mention.mention("accountid:foo"), Mention.mention("foo"), Mention.mention("original")));
    }

    private void addParagraphs() {
        this.add((DocContent)Paragraph.p(Text.text("x").em().strike().strong().sup().textColor(Color.RED).underline(), Text.text("sub").sub().strong(), Text.text("link").link("http://example.com").underline(), Text.text("code").code()));
    }

    private void addPanels() {
        this.add(Panel.warning("foo"), Panel.info(CodeBlock.codeBlock("echo hello"), (PanelContent)((Extension)Extension.extension().extensionKey("extension-key").extensionType("extension-type").mark(Fragment.fragment("local-id"))).mark(DataConsumer.dataConsumer("source1", "source2"))));
    }

    private void addRules() {
        this.add((DocContent)Rule.hr());
    }

    private void addStatuses() {
        this.add((DocContent)Paragraph.p(Status.blue("blue"), Status.neutral("Foo")));
    }

    private void addTables() {
        this.add(Table.table(TableRow.tr(TableHeader.th("a"), TableHeader.th("b")), TableRow.tr(TableCell.td("c"), TableCell.td("d")), TableRow.tr(TableCell.td("xyzzy"), TableCell.td((TableCellContent)NestedExpand.nestedExpand(Paragraph.p("foo"), CodeBlock.codeBlock("echo hello"), (NestedExpandContent)((Extension)Extension.extension().extensionKey("extension-key").extensionType("extension-type").mark(Fragment.fragment("local-id"))).mark(DataConsumer.dataConsumer("source1", "source2")))))), Table.table(TableRow.tr(((TableHeader)TableHeader.th("foo").background("#ff0000")).colspan(2)), TableRow.tr(TableCell.td("bar"), TableCell.td("baz"))));
    }

    private void addTaskLists() {
        this.add((DocContent)((Object)TaskList.taskList("tl1").content(new TaskListContent[]{TaskItem.taskItem().todo().localId("ti1.1").content("item 1.1"), TaskItem.taskItem().done().localId("ti1.2").content("item 1.2"), (TaskListContent)((Object)TaskList.taskList("tl2").content(TaskItem.taskItem().todo().localId("ti2.1").content("item 2.1")))})));
    }

    private void addTexts() {
        this.add(Paragraph.p((InlineContent)Text.text("code").code()), CodeBlock.codeBlock("noformat"), CodeBlock.codeBlock("code").language("javascript"), Paragraph.p("foo !foo.png! [foo:bar.jpg] [~foo] [^foo.png] {x} {color} {noformat} \\ \\! \\\\ \\\\\\ bar"));
    }

    private void addUnknowns() {
        this.add((DocContent)((Object)BodiedExtension.bodiedExtension().extensionKey("foo").extensionType("bar").content(Paragraph.p())), Paragraph.p((InlineContent)InlineExtension.inlineExtension().extensionKey("asdf").extensionType("sdf").text("text")));
    }
}

