/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.ex.node.TaskListException;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.ExtensionFrameContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.ListItemContent;
import com.atlassian.adf.model.node.type.NestedExpandContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.PanelContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.model.node.type.TaskListContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;

@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class TaskList
extends AbstractContentNode<TaskList, TaskListContent>
implements DocContent,
ExtensionFrameContent,
LayoutColumnContent,
ListItemContent,
NestedExpandContent,
NonNestableBlockContent,
PanelContent,
TableCellContent,
TaskListContent {
    static final Factory<TaskList> FACTORY = new Factory<TaskList>("taskList", TaskList.class, TaskList::parse);
    private String localId;

    private TaskList(String localId) {
        this.localId = Objects.requireNonNull(localId, "localId");
    }

    public static TaskList taskList(String localId) {
        return new TaskList(localId);
    }

    public static TaskList taskList(String localId, TaskListContent content) {
        return (TaskList)TaskList.taskList(localId).content(content);
    }

    public static TaskList taskList(String localId, TaskListContent ... content) {
        return (TaskList)TaskList.taskList(localId).content(content);
    }

    public static TaskList taskList(String localId, Iterable<? extends TaskListContent> content) {
        return (TaskList)TaskList.taskList(localId).content(content);
    }

    public static TaskList taskList(String localId, Stream<? extends TaskListContent> content) {
        return (TaskList)TaskList.taskList(localId).content(content);
    }

    public static TaskList taskList(UUID localId) {
        return TaskList.taskList(Objects.requireNonNull(localId, "localId").toString());
    }

    public static TaskList taskList(UUID localId, TaskListContent content) {
        return (TaskList)TaskList.taskList(localId).content(content);
    }

    public static TaskList taskList(UUID localId, TaskListContent ... content) {
        return (TaskList)TaskList.taskList(localId).content(content);
    }

    public static TaskList taskList(UUID localId, Iterable<? extends TaskListContent> content) {
        return (TaskList)TaskList.taskList(localId).content(content);
    }

    public static TaskList taskList(UUID localId, Stream<? extends TaskListContent> content) {
        return (TaskList)TaskList.taskList(localId).content(content);
    }

    public TaskList localId(String localId) {
        this.localId = Objects.requireNonNull(localId, "localId");
        return this;
    }

    public TaskList localId(UUID localId) {
        return this.localId(Objects.requireNonNull(localId, "localId").toString());
    }

    public String localId() {
        return this.localId;
    }

    @Override
    public Class<TaskListContent> contentClass() {
        return TaskListContent.class;
    }

    @Override
    public TaskList copy() {
        return TaskList.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "taskList";
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        return this.mapWithType().let(this::addContent).add("attrs", FieldMap.map("localId", this.localId));
    }

    @Override
    protected boolean contentNodeEquals(TaskList other) {
        return this.localId.equals(other.localId);
    }

    @Override
    protected int contentNodeHashCode() {
        return this.localId.hashCode();
    }

    @Override
    protected void appendContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("localId", this.localId);
    }

    private void validateFirstContentItemIsNotAList() {
        this.requireNotEmpty();
        TaskListContent firstContentItem = (TaskListContent)this.content.get(0);
        if (firstContentItem instanceof TaskList) {
            throw new TaskListException.CannotUseNestedTaskListAsFirstContentItem();
        }
    }

    @Override
    protected void validateContentNodeForAppend(TaskListContent node) {
        if (this.content.isEmpty() && node instanceof TaskList) {
            throw new TaskListException.CannotUseNestedTaskListAsFirstContentItem();
        }
        super.validateContentNodeForAppend(node);
    }

    @Override
    protected void contentNodeValidate() {
        this.validateFirstContentItemIsNotAList();
    }

    private static TaskList parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "taskList");
        return (TaskList)TaskList.taskList(ParserSupport.getAttrOrThrow(map, "localId", String.class)).parseRequiredContent(map, TaskListContent.class);
    }
}

