/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.ex.node.MediaException;
import com.atlassian.adf.model.mark.Link;
import com.atlassian.adf.model.mark.MarkKey;
import com.atlassian.adf.model.mark.type.MediaSingleMark;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.AbstractMarkedNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.Caption;
import com.atlassian.adf.model.node.Media;
import com.atlassian.adf.model.node.Node;
import com.atlassian.adf.model.node.NodeParserSupport;
import com.atlassian.adf.model.node.RichMedia;
import com.atlassian.adf.model.node.type.BlockquoteContent;
import com.atlassian.adf.model.node.type.CaptionContent;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.ExtensionFrameContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.ListItemContent;
import com.atlassian.adf.model.node.type.NestedExpandContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.PanelContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import com.atlassian.annotations.Internal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class MediaSingle
extends AbstractMarkedNode<MediaSingle, MediaSingleMark>
implements BlockquoteContent,
DocContent,
ExtensionFrameContent,
LayoutColumnContent,
ListItemContent,
NestedExpandContent,
NonNestableBlockContent,
PanelContent,
TableCellContent {
    static Factory<MediaSingle> FACTORY = new Factory<MediaSingle>("mediaSingle", MediaSingle.class, MediaSingle::parse);
    private RichMedia.Layout layout;
    private Media media;
    private Width width = Width.UNSET;
    @Nullable
    private Caption caption;

    private MediaSingle(RichMedia.Layout layout, Media media) {
        this.layout = Objects.requireNonNull(layout, "layout");
        this.media = Objects.requireNonNull(media, "media");
    }

    public static Partial.NeedsMedia mediaSingle() {
        return new Partial.NeedsMedia(RichMedia.Layout.CENTER);
    }

    public static MediaSingle mediaSingle(Media media) {
        return new MediaSingle(RichMedia.Layout.CENTER, media);
    }

    public static Partial.NeedsMedia mediaSingle(RichMedia.Layout layout) {
        return new Partial.NeedsMedia(layout);
    }

    public static MediaSingle mediaSingle(String layout, Media media) {
        return new MediaSingle(RichMedia.Layout.PARSER.parse(layout), media);
    }

    public static MediaSingle mediaSingle(RichMedia.Layout layout, Media media) {
        return new MediaSingle(layout, media);
    }

    public Optional<Number> width() {
        return this.width.width();
    }

    public Optional<WidthType> widthType() {
        return this.width.widthType();
    }

    public MediaSingle width(@Nullable Number width) {
        this.width = Width.width(width, null);
        return this;
    }

    public MediaSingle widthAsPercentage(@Nullable Number width) {
        this.width = Width.width(width, WidthType.PERCENTAGE);
        return this;
    }

    public MediaSingle widthInPixels(@Nullable Number width) {
        this.width = Width.width(width, WidthType.PIXEL);
        return this;
    }

    public Media media() {
        return this.media;
    }

    public MediaSingle media(Media media) {
        this.media = Objects.requireNonNull(media, "media");
        return this;
    }

    public Optional<Caption> caption() {
        return Optional.ofNullable(this.caption);
    }

    public MediaSingle caption(@Nullable Caption caption) {
        this.caption = caption;
        return this;
    }

    public MediaSingle caption(String captionContent) {
        this.caption = Caption.caption(captionContent);
        return this;
    }

    public MediaSingle caption(String ... captionContent) {
        this.caption = Caption.caption(captionContent);
        return this;
    }

    public MediaSingle caption(CaptionContent captionContent) {
        this.caption = Caption.caption(captionContent);
        return this;
    }

    public MediaSingle caption(CaptionContent ... captionContent) {
        this.caption = Caption.caption(captionContent);
        return this;
    }

    public MediaSingle caption(Iterable<? extends CaptionContent> captionContent) {
        this.caption = Caption.caption(captionContent);
        return this;
    }

    public MediaSingle caption(Stream<? extends CaptionContent> captionContent) {
        this.caption = Caption.caption(captionContent);
        return this;
    }

    public RichMedia.Layout layout() {
        return this.layout;
    }

    public MediaSingle layout(String layout) {
        this.layout = RichMedia.Layout.PARSER.parse(layout);
        return this;
    }

    public MediaSingle layout(RichMedia.Layout layout) {
        this.layout = Objects.requireNonNull(layout, "layout");
        return this;
    }

    public MediaSingle wrapLeft() {
        return this.layout(RichMedia.Layout.WRAP_LEFT);
    }

    public MediaSingle center() {
        return this.layout(RichMedia.Layout.CENTER);
    }

    public MediaSingle wrapRight() {
        return this.layout(RichMedia.Layout.WRAP_RIGHT);
    }

    public MediaSingle wide() {
        return this.layout(RichMedia.Layout.WIDE);
    }

    public MediaSingle fullWidth() {
        return this.layout(RichMedia.Layout.FULL_WIDTH);
    }

    public MediaSingle alignStart() {
        return this.layout(RichMedia.Layout.ALIGN_START);
    }

    public MediaSingle alignEnd() {
        return this.layout(RichMedia.Layout.ALIGN_END);
    }

    @Override
    public MediaSingle copy() {
        return MediaSingle.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "mediaSingle";
    }

    @Override
    protected boolean markedNodeEquals(MediaSingle other) {
        return this.layout == other.layout && this.media.equals(other.media) && this.width.equals(other.width) && Objects.equals(this.caption, other.caption);
    }

    @Override
    protected int markedNodeHashCode() {
        return Objects.hash(new Object[]{this.layout, this.media, this.width, this.caption});
    }

    @Override
    protected void appendMarkedNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("layout", (Object)this.layout);
        buf.appendField("width", this.width);
        buf.appendField("media", this.media);
        buf.appendField("caption", this.caption);
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        this.media.appendPlainText(sb);
        Caption caption = this.caption;
        if (caption != null) {
            caption.appendPlainText(sb);
        }
    }

    @Override
    public Class<MediaSingleMark> markClass() {
        return MediaSingleMark.class;
    }

    @Override
    public MediaSingle mark(MediaSingleMark mark) {
        this.marks.add(mark);
        return this;
    }

    public MediaSingle link(@Nullable Link link) {
        this.marks.remove(MarkKey.link());
        if (link != null) {
            this.marks.add(link);
        }
        return this;
    }

    public MediaSingle link(@Nullable String href) {
        return this.link(href != null ? Link.link(href) : null);
    }

    public Optional<Link> link() {
        return this.marks.get(MarkKey.link()).map(Link.class::cast);
    }

    @Override
    public Map<String, ?> toMap() {
        ArrayList content = new ArrayList(2);
        content.add(this.media.toMap());
        Optional.ofNullable(this.caption).map(Element::toMap).ifPresent(content::add);
        return this.mapWithType().add("attrs", FieldMap.map().let(this.width::addToAttrMap).addMapped("layout", this.layout, RichMedia.Layout::layout)).add("content", content).let(this.marks::addToMap);
    }

    private static MediaSingle parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "mediaSingle");
        RichMedia.Layout layout = ParserSupport.getAttr(map, "layout", String.class).map(RichMedia.Layout.PARSER::parse).orElse(RichMedia.Layout.CENTER);
        List<Map<String, ?>> contentMaps = AbstractContentNode.getRequiredContentMaps(map);
        Media media = AdfException.frame("[0]", () -> NodeParserSupport.getNodeOfType(Media.class, (Map)contentMaps.get(0), "mediaSingle"));
        MediaSingle mediaSingle = new MediaSingle(layout, media);
        mediaSingle.width = Width.parseWidth(map);
        mediaSingle.parseMarks(map);
        int count = contentMaps.size();
        if (count > 1) {
            AdfException.frame("[1]", () -> mediaSingle.caption(NodeParserSupport.getNodeOfType(Caption.class, (Map)contentMaps.get(1), mediaSingle)));
            if (count > 2) {
                throw new MediaException.TooManyContentItems(count).backtrace("[2]");
            }
        }
        return mediaSingle;
    }

    public Stream<Node> allNodes() {
        Caption caption = this.caption;
        Stream<Node> stream = Stream.of(this, this.media);
        if (caption != null) {
            stream = Stream.concat(stream, caption.allNodes());
        }
        return stream;
    }

    public <T extends Node> Stream<T> allNodesOfType(Class<T> nodeClass) {
        return this.allNodes().filter(nodeClass::isInstance).map(nodeClass::cast);
    }

    public <T extends Node> List<T> allNodesOfTypeAsList(Class<T> nodeClass) {
        return this.allNodesOfType(nodeClass).collect(Collectors.toList());
    }

    @CheckReturnValue
    @Internal
    <T extends Node> boolean transformDescendantsInternal(Class<T> targetNodeClass, Function<? super T, ? extends T> transformer) {
        if (targetNodeClass.isInstance(this.media)) {
            Node result = (Node)transformer.apply(targetNodeClass.cast(this.media));
            if (result == null) {
                return true;
            }
            this.media = (Media)Cast.unsafeCast(result);
        }
        if (targetNodeClass.isInstance(this.caption)) {
            this.caption = (Caption)Cast.unsafeCast(transformer.apply(targetNodeClass.cast(this.caption)));
        }
        if (this.caption != null) {
            this.caption.transformDescendants(targetNodeClass, transformer);
        }
        return false;
    }

    public <T extends Node> List<ContentNode.MatchContainer<T>> findMatchingDescendants(Class<T> nodeClass, Predicate<? super T> predicate) {
        AbstractContentNode.FindMatchingDescendants<T> visitor = new AbstractContentNode.FindMatchingDescendants<T>(nodeClass, predicate);
        visitor.accept(this, this.contentInternal());
        return visitor.result();
    }

    @Internal
    List<Node> contentInternal() {
        Caption caption = this.caption;
        return caption != null ? List.of(this.media, caption) : List.of(this.media);
    }

    @Immutable
    static class Width {
        static final Width UNSET = new Width(null, null);
        @Nullable
        private final Number width;
        @Nullable
        private final WidthType widthType;

        private Width(@Nullable Number width, @Nullable WidthType widthType) {
            this.width = width;
            this.widthType = widthType;
        }

        static Width width(@Nullable Number width, @Nullable WidthType widthType) {
            if (width == null) {
                return UNSET;
            }
            if (widthType == WidthType.PIXEL) {
                return new Width(Width.validateWidthInPixels(width), WidthType.PIXEL);
            }
            Width.validateWidthAsPercentage(width);
            return new Width(width, widthType);
        }

        private static int validateWidthInPixels(Number width) {
            int widthInt = width.intValue();
            if (widthInt < 0) {
                throw new MediaException.WidthMustBeValidPixelCount(widthInt);
            }
            return widthInt;
        }

        private static void validateWidthAsPercentage(Number width) {
            double widthDouble = width.doubleValue();
            if (widthDouble < 0.0 || widthDouble > 100.0) {
                throw new MediaException.WidthMustBeValidPercentage(width);
            }
        }

        Optional<WidthType> widthType() {
            return Optional.ofNullable(this.widthType);
        }

        Optional<Number> width() {
            return Optional.ofNullable(this.width);
        }

        void addToAttrMap(FieldMap attrs) {
            if (this.width == null) {
                return;
            }
            attrs.add("width", this.width);
            attrs.addMappedIfPresent("widthType", this.widthType, WidthType::widthType);
        }

        static Width parseWidth(Map<String, ?> map) {
            Number width = ParserSupport.getAttr(map, "width", Number.class).orElse(null);
            if (width == null) {
                return UNSET;
            }
            WidthType widthType = ParserSupport.getAttr(map, "widthType", String.class).map(WidthType.PARSER::parse).orElse(null);
            return Width.width(width, widthType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Width)) {
                return false;
            }
            Width other = (Width)o;
            return AbstractNode.numberEq(this.width, other.width) && this.widthType == other.widthType;
        }

        public int hashCode() {
            return Objects.hashCode((Object)this.widthType) * 31 + AbstractNode.numberHash(this.width);
        }

        public String toString() {
            return this.width != null ? "Width{width=" + String.valueOf(this.width) + ", widthType=" + String.valueOf((Object)this.widthType) + "}" : "UNSET";
        }
    }

    public static interface Partial {

        public static class NeedsMedia {
            private RichMedia.Layout layout;
            private Width width = Width.UNSET;

            NeedsMedia(RichMedia.Layout layout) {
                this.layout = Objects.requireNonNull(layout, "layout");
            }

            public NeedsMedia layout(String layout) {
                return this.layout(RichMedia.Layout.PARSER.parse(layout));
            }

            public NeedsMedia layout(RichMedia.Layout layout) {
                this.layout = Objects.requireNonNull(layout, "layout");
                return this;
            }

            public NeedsMedia wrapLeft() {
                return this.layout(RichMedia.Layout.WRAP_LEFT);
            }

            public NeedsMedia center() {
                return this.layout(RichMedia.Layout.CENTER);
            }

            public NeedsMedia wrapRight() {
                return this.layout(RichMedia.Layout.WRAP_RIGHT);
            }

            public NeedsMedia wide() {
                return this.layout(RichMedia.Layout.WIDE);
            }

            public NeedsMedia fullWidth() {
                return this.layout(RichMedia.Layout.FULL_WIDTH);
            }

            public NeedsMedia alignStart() {
                return this.layout(RichMedia.Layout.ALIGN_START);
            }

            public NeedsMedia alignEnd() {
                return this.layout(RichMedia.Layout.ALIGN_END);
            }

            @CheckReturnValue
            public NeedsMedia width(@Nullable Number width) {
                this.width = Width.width(width, null);
                return this;
            }

            @CheckReturnValue
            public NeedsMedia widthAsPercentage(@Nullable Number width) {
                this.width = Width.width(width, WidthType.PERCENTAGE);
                return this;
            }

            @CheckReturnValue
            public NeedsMedia widthInPixels(@Nullable Number width) {
                this.width = Width.width(width, WidthType.PIXEL);
                return this;
            }

            @CheckReturnValue
            public MediaSingle media(Media media) {
                MediaSingle mediaSingle = new MediaSingle(this.layout, media);
                mediaSingle.width = this.width;
                return mediaSingle;
            }
        }
    }

    public static enum WidthType {
        PERCENTAGE("percentage"),
        PIXEL("pixel");

        static final EnumParser<WidthType> PARSER;
        private final String widthType;

        private WidthType(String widthType) {
            this.widthType = widthType;
        }

        public String widthType() {
            return this.widthType;
        }

        static {
            PARSER = new EnumParser<WidthType>(WidthType.class, WidthType::widthType);
        }
    }
}

