/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.ex.node.MediaException;
import com.atlassian.adf.model.mark.Border;
import com.atlassian.adf.model.mark.Link;
import com.atlassian.adf.model.mark.MarkKey;
import com.atlassian.adf.model.mark.MarkParserSupport;
import com.atlassian.adf.model.mark.type.MediaMark;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.MarkHolder;
import com.atlassian.adf.model.node.Node;
import com.atlassian.adf.model.node.type.InternalMediaNode;
import com.atlassian.adf.model.node.type.Marked;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.Fold3;
import com.atlassian.adf.util.Functions;
import com.atlassian.adf.util.ParserSupport;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.WRONG, date="2023-07-26", comment="'external' type, its different requirements, and the 'link' and 'border' marks are undocumented")
public interface Media
extends Node,
Marked<Media, MediaMark>,
Fold3<FileMedia, LinkMedia, ExternalMedia> {
    public static final Factory<Media> FACTORY = new Factory<Media>("media", Media.class, AbstractMedia::parse);

    @CheckReturnValue
    public static Partial.NeedsType media() {
        return new Partial.NeedsType();
    }

    @CheckReturnValue
    public static Partial.FileNeedsId fileMedia() {
        return new Partial.FileNeedsId();
    }

    @CheckReturnValue
    public static FileMedia fileMedia(String id) {
        return new FileMedia(id);
    }

    public static FileMedia fileMedia(String id, @Nullable String collection) {
        return (FileMedia)new FileMedia(id).collection(collection);
    }

    @CheckReturnValue
    public static Partial.LinkNeedsId linkMedia() {
        return new Partial.LinkNeedsId();
    }

    @CheckReturnValue
    public static LinkMedia linkMedia(String id) {
        return new LinkMedia(id);
    }

    public static LinkMedia linkMedia(String id, @Nullable String collection) {
        return (LinkMedia)new LinkMedia(id).collection(collection);
    }

    @CheckReturnValue
    public static Partial.ExternalNeedsUrl externalMedia() {
        return new Partial.ExternalNeedsUrl();
    }

    public static ExternalMedia externalMedia(String url) {
        return Media.externalMedia().url(url);
    }

    public static ExternalMedia externalMedia(URL url) {
        return Media.externalMedia().url(url);
    }

    public static ExternalMedia externalMedia(URI url) {
        return Media.externalMedia().url(url);
    }

    public MediaType type();

    public Optional<Number> width();

    public Media width(@Nullable Number var1);

    public Optional<Number> height();

    public Media height(@Nullable Number var1);

    public Media size(@Nullable Number var1, @Nullable Number var2);

    @Override
    public <R> R fold(Function<? super FileMedia, ? extends R> var1, Function<? super LinkMedia, ? extends R> var2, Function<? super ExternalMedia, ? extends R> var3);

    public Optional<String> alt();

    public Media alt(@Nullable String var1);

    public Media linkMark(@Nullable Link var1);

    public Media linkMark(@Nullable URL var1);

    public Media linkMark(@Nullable String var1);

    public Optional<Link> linkMark();

    public Media border(@Nullable Border var1);

    public Media border(String var1);

    public Media border(int var1, String var2);

    public Optional<Border> border();

    public Optional<FileMedia> file();

    @Deprecated
    public Optional<LinkMedia> link();

    public Optional<ExternalMedia> external();

    public void ifFile(Consumer<? super FileMedia> var1);

    @Deprecated
    public void ifLink(Consumer<? super LinkMedia> var1);

    public void ifExternal(Consumer<? super ExternalMedia> var1);

    public boolean isFile();

    @Deprecated
    public boolean isLink();

    public boolean isExternal();

    public static interface Partial {

        public static class ExternalNeedsUrl {
            public ExternalMedia url(String url) {
                return new ExternalMedia(ParserSupport.cleanUri(url, "url"));
            }

            public ExternalMedia url(URL url) {
                return new ExternalMedia(ParserSupport.cleanUri(url, "url"));
            }

            public ExternalMedia url(URI url) {
                return new ExternalMedia(ParserSupport.cleanUri(url, "url"));
            }
        }

        @Deprecated
        public static class LinkNeedsCollection {
            private final String id;

            LinkNeedsCollection(String id) {
                this.id = Element.nonNull(id, "id");
            }

            public LinkMedia collection(@Nullable String collection) {
                return (LinkMedia)new LinkMedia(this.id).collection(collection);
            }
        }

        @Deprecated
        public static class LinkNeedsId {
            LinkNeedsId() {
            }

            @CheckReturnValue
            public LinkMedia id(String id) {
                return new LinkMedia(id);
            }
        }

        public static class FileNeedsId {
            FileNeedsId() {
            }

            @CheckReturnValue
            public FileMedia id(String id) {
                return new FileMedia(id);
            }
        }

        public static class NeedsType {
            NeedsType() {
            }

            public FileNeedsId file() {
                return new FileNeedsId();
            }

            @Deprecated
            public LinkNeedsId link() {
                return new LinkNeedsId();
            }

            public ExternalNeedsUrl external() {
                return new ExternalNeedsUrl();
            }
        }
    }

    public static class FileMedia
    extends FileOrLinkMedia<FileMedia> {
        FileMedia(String id) {
            super(id);
        }

        @Override
        public FileMedia copy() {
            return (FileMedia)Cast.unsafeCast(FileMedia.parse(this.toMap()));
        }

        @Override
        public MediaType type() {
            return MediaType.FILE;
        }

        @Override
        public Optional<FileMedia> file() {
            return Optional.of(this);
        }

        @Override
        public Optional<LinkMedia> link() {
            return Optional.empty();
        }

        @Override
        public boolean isFile() {
            return true;
        }

        @Override
        @Deprecated
        public boolean isLink() {
            return false;
        }

        @Override
        public <R> R fold(Function<? super FileMedia, ? extends R> ifFile, Function<? super LinkMedia, ? extends R> ifLink, Function<? super ExternalMedia, ? extends R> ifExternal) {
            return ifFile.apply(this);
        }

        static FileMedia parseFile(Map<String, ?> map) {
            String id = (String)ParserSupport.getAttrOrThrow(map, "id");
            String collection = ParserSupport.getAttr(map, "collection", String.class).orElse(null);
            FileMedia media = (FileMedia)new FileMedia(id).collection(collection);
            ParserSupport.getAttr(map, "occurrenceKey", String.class).ifPresent(media::occurrenceKey);
            return media;
        }
    }

    public static abstract class FileOrLinkMedia<T extends FileOrLinkMedia<T>>
    extends AbstractMedia<T>
    implements InternalMediaNode {
        protected String id;
        protected String collection = "";
        @Nullable
        protected String occurrenceKey;

        FileOrLinkMedia(String id) {
            this.id = FileOrLinkMedia.validateId(id);
        }

        public T id(String id) {
            this.id = FileOrLinkMedia.validateId(id);
            return (T)((FileOrLinkMedia)this.self());
        }

        public T collection(@Nullable String collection) {
            this.collection = FileOrLinkMedia.validateCollection(collection);
            return (T)((FileOrLinkMedia)this.self());
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String collection() {
            return this.collection;
        }

        @Override
        public Optional<String> occurrenceKey() {
            return Optional.ofNullable(this.occurrenceKey);
        }

        public T occurrenceKey(@Nullable String occurrenceKey) {
            this.occurrenceKey = FileOrLinkMedia.validateOccurrenceKey(occurrenceKey);
            return (T)((FileOrLinkMedia)this.self());
        }

        @Override
        public Optional<ExternalMedia> external() {
            return Optional.empty();
        }

        @Override
        public boolean isExternal() {
            return false;
        }

        @Override
        public boolean isImage() {
            return false;
        }

        @Override
        public Map<String, ?> toMap() {
            return this.mapWithType().add("attrs", FieldMap.map().add("type", this.type().mediaType()).add("id", this.id).addIfPresent("alt", this.alt).add("collection", this.collection).addIfPresent("occurrenceKey", this.occurrenceKey).let(this::addCommonAttrs)).let(this.marks::addToMap);
        }

        @Override
        protected final boolean mediaEquals(T other) {
            return this.id.equals(((FileOrLinkMedia)other).id) && this.collection.equals(((FileOrLinkMedia)other).collection) && Objects.equals(this.occurrenceKey, ((FileOrLinkMedia)other).occurrenceKey);
        }

        @Override
        protected final int mediaHashCode() {
            return Objects.hash(this.id, this.collection, this.occurrenceKey);
        }

        @Override
        protected final void appendMediaFields(AbstractNode.ToStringHelper buf) {
            buf.appendField("id", this.id);
            buf.appendField("collection", this.collection);
            buf.appendField("occurrenceKey", this.occurrenceKey);
        }

        private static String validateId(String id) {
            return Element.nonEmpty(id, "id");
        }

        private static String validateCollection(@Nullable String collection) {
            return collection != null ? collection : "";
        }

        @Nullable
        private static String validateOccurrenceKey(@Nullable String occurrenceKey) {
            return occurrenceKey != null && occurrenceKey.isEmpty() ? null : occurrenceKey;
        }

        @Override
        public abstract FileOrLinkMedia<T> copy();
    }

    public static class LinkMedia
    extends FileOrLinkMedia<LinkMedia> {
        LinkMedia(String id) {
            super(id);
        }

        @Override
        public LinkMedia copy() {
            return (LinkMedia)Cast.unsafeCast(LinkMedia.parse(this.toMap()));
        }

        @Override
        public MediaType type() {
            return MediaType.LINK;
        }

        @Override
        public Optional<FileMedia> file() {
            return Optional.empty();
        }

        @Override
        public Optional<LinkMedia> link() {
            return Optional.of(this);
        }

        @Override
        public boolean isFile() {
            return false;
        }

        @Override
        @Deprecated
        public boolean isLink() {
            return true;
        }

        @Override
        public <R> R fold(Function<? super FileMedia, ? extends R> ifFile, Function<? super LinkMedia, ? extends R> ifLink, Function<? super ExternalMedia, ? extends R> ifExternal) {
            return ifLink.apply(this);
        }

        static LinkMedia parseLink(Map<String, ?> map) {
            String id = (String)ParserSupport.getAttrOrThrow(map, "id");
            String collection = ParserSupport.getAttr(map, "collection", String.class).orElse(null);
            LinkMedia media = (LinkMedia)new LinkMedia(id).collection(collection);
            ParserSupport.getAttr(map, "occurrenceKey", String.class).ifPresent(media::occurrenceKey);
            return media;
        }
    }

    public static class ExternalMedia
    extends AbstractMedia<ExternalMedia> {
        private final String url;

        ExternalMedia(String url) {
            this.url = Objects.requireNonNull(url, "url");
        }

        @Override
        public ExternalMedia copy() {
            return (ExternalMedia)Cast.unsafeCast(ExternalMedia.parse(this.toMap()));
        }

        public String url() {
            return this.url;
        }

        @Override
        public MediaType type() {
            return MediaType.EXTERNAL;
        }

        @Override
        public <R> R fold(Function<? super FileMedia, ? extends R> ifFile, Function<? super LinkMedia, ? extends R> ifLink, Function<? super ExternalMedia, ? extends R> ifExternal) {
            return ifExternal.apply(this);
        }

        @Override
        public Optional<FileMedia> file() {
            return Optional.empty();
        }

        @Override
        public Optional<LinkMedia> link() {
            return Optional.empty();
        }

        @Override
        public Optional<ExternalMedia> external() {
            return Optional.of(this);
        }

        @Override
        public boolean isFile() {
            return false;
        }

        @Override
        @Deprecated
        public boolean isLink() {
            return false;
        }

        @Override
        public boolean isExternal() {
            return true;
        }

        @Override
        public Map<String, ?> toMap() {
            return this.mapWithType().add("attrs", FieldMap.map().add("type", MediaType.EXTERNAL.mediaType()).add("url", this.url).addIfPresent("alt", this.alt).let(this::addCommonAttrs)).let(this.marks::addToMap);
        }

        static ExternalMedia parseExternal(Map<String, ?> map) {
            String url = ParserSupport.getAttrOrThrow(map, "url", String.class);
            return new ExternalMedia(url);
        }

        @Override
        protected boolean mediaEquals(ExternalMedia other) {
            return this.url.equals(other.url);
        }

        @Override
        protected int mediaHashCode() {
            return this.url.hashCode();
        }

        @Override
        protected void appendMediaFields(AbstractNode.ToStringHelper buf) {
            buf.appendField("url", this.url);
        }
    }

    public static abstract class AbstractMedia<N extends AbstractMedia<N>>
    extends AbstractNode<N>
    implements Media {
        @Nullable
        protected Number width;
        @Nullable
        protected Number height;
        @Nullable
        protected String alt;
        final MarkHolder<MediaMark> marks = MarkHolder.unlimited();

        @Override
        public final Class<MediaMark> markClass() {
            return MediaMark.class;
        }

        @Override
        public N mark(MediaMark mark) {
            this.marks.add(mark);
            return (N)((AbstractMedia)this.self());
        }

        @Override
        public boolean markIfAllowed(MediaMark mark) {
            return this.marks.addIfAllowed(mark).isEmpty();
        }

        public N link(Link link) {
            return this.mark(link);
        }

        public N link(String href) {
            return this.mark(Link.link(href));
        }

        public N linkMark(@Nullable Link link) {
            this.marks.removeAll(Link.class);
            if (link != null) {
                this.marks.add(link);
            }
            return (N)((AbstractMedia)this.self());
        }

        public N linkMark(@Nullable URL url) {
            return (N)this.linkMark(url != null ? Link.link(url) : null);
        }

        public N linkMark(@Nullable String href) {
            return (N)this.linkMark(href != null ? Link.link(href) : null);
        }

        @Override
        public Optional<Link> linkMark() {
            return this.marks.get(MarkKey.link()).map(Link.class::cast);
        }

        @Override
        public Optional<Border> border() {
            return this.marks.get(MarkKey.border()).map(Border.class::cast);
        }

        public N border(@Nullable Border border) {
            this.marks.removeAll("border");
            if (border != null) {
                this.marks.add(border);
            }
            return (N)((AbstractMedia)this.self());
        }

        public N border(@Nullable String color) {
            return (N)this.border(color != null ? Border.border().color(color) : null);
        }

        public N border(int size, String color) {
            Border border = Border.border().size(size).color(color);
            return (N)this.border(border);
        }

        @Override
        public Collection<MediaMark> marks() {
            return this.marks.get();
        }

        @Override
        public Set<String> markTypes() {
            return this.marks.getTypes();
        }

        @Override
        public <T extends MediaMark> Stream<? extends T> marks(Class<T> markClass) {
            return this.marks.stream(markClass);
        }

        @Override
        public Optional<MediaMark> mark(MarkKey markKey) {
            return this.marks.get(markKey);
        }

        @Override
        @Deprecated
        public Optional<MediaMark> mark(String type) {
            return this.marks.findFirst(type);
        }

        @Override
        public void accept(Consumer<? super FileMedia> ifFile, Consumer<? super LinkMedia> ifLink, Consumer<? super ExternalMedia> ifExternal) {
            this.fold(Functions.voidFn(ifFile), Functions.voidFn(ifLink), Functions.voidFn(ifExternal));
        }

        @Override
        public Optional<Number> width() {
            return Optional.ofNullable(this.width);
        }

        public N width(@Nullable Number width) {
            if (width != null && width.doubleValue() <= 0.0) {
                throw new MediaException.WidthMustBePositive(width);
            }
            this.width = width;
            return (N)((AbstractMedia)this.self());
        }

        @Override
        public Optional<Number> height() {
            return Optional.ofNullable(this.height);
        }

        public N height(@Nullable Number height) {
            if (height != null && height.doubleValue() <= 0.0) {
                throw new MediaException.HeightMustBePositive(height);
            }
            this.height = height;
            return (N)((AbstractMedia)this.self());
        }

        public N size(@Nullable Number width, @Nullable Number height) {
            return (N)((AbstractMedia)this.width(width)).height(height);
        }

        @Override
        public Optional<String> alt() {
            return Optional.ofNullable(this.alt);
        }

        public N alt(@Nullable String alt) {
            this.alt = alt;
            return (N)((AbstractMedia)this.self());
        }

        @Override
        public void ifFile(Consumer<? super FileMedia> effect) {
            this.file().ifPresent(effect);
        }

        @Override
        @Deprecated
        public void ifLink(Consumer<? super LinkMedia> effect) {
            this.link().ifPresent(effect);
        }

        @Override
        public void ifExternal(Consumer<? super ExternalMedia> effect) {
            this.external().ifPresent(effect);
        }

        @Override
        public String elementType() {
            return "media";
        }

        @Override
        public void validate() {
        }

        @Override
        protected final boolean nodeEquals(N other) {
            return Objects.equals(this.alt, ((AbstractMedia)other).alt) && AbstractMedia.numberEq(this.width, ((AbstractMedia)other).width) && AbstractMedia.numberEq(this.height, ((AbstractMedia)other).height) && this.mediaEquals(other) && this.marks.equals(((AbstractMedia)other).marks);
        }

        @Override
        protected int nodeHashCode() {
            return Objects.hash(this.getClass(), AbstractMedia.numberHash(this.width), AbstractMedia.numberHash(this.height), this.alt, this.mediaHashCode(), this.marks);
        }

        @Override
        protected void appendNodeFields(AbstractNode.ToStringHelper buf) {
            buf.appendField("mediaType", (Object)this.type());
            buf.appendField("width", this.width);
            buf.appendField("height", this.height);
            buf.appendField("alt", this.alt);
            this.appendMediaFields(buf);
            buf.appendMarksField(this.marks);
        }

        protected abstract boolean mediaEquals(N var1);

        protected abstract int mediaHashCode();

        protected abstract void appendMediaFields(AbstractNode.ToStringHelper var1);

        protected void addCommonAttrs(FieldMap attrs) {
            attrs.addIfPresent("height", this.height);
            attrs.addIfPresent("width", this.width);
        }

        protected void parseCommonAttrs(Map<String, ?> map) {
            ParserSupport.getAttrNumber(map, "width").filter(x -> x.doubleValue() > 0.0).ifPresent(number -> this.width((Number)number));
            ParserSupport.getAttrNumber(map, "height").filter(x -> x.doubleValue() > 0.0).ifPresent(number -> this.height((Number)number));
            ParserSupport.getAttr(map, "alt", String.class).ifPresent(string -> this.alt((String)string));
        }

        static Media parse(Map<String, ?> map) {
            ParserSupport.checkType(map, "media");
            MediaType type = MediaType.PARSER.parse(ParserSupport.getAttrOrThrow(map, "type", String.class));
            AbstractMedia<?> media = type.parse(map);
            media.parseCommonAttrs(map);
            MarkParserSupport.parseMarks(map, MediaMark.class, null, media);
            return media;
        }
    }

    public static enum MediaType {
        FILE("file", FileMedia::parseFile),
        LINK("link", LinkMedia::parseLink),
        EXTERNAL("external", ExternalMedia::parseExternal);

        static final EnumParser<MediaType> PARSER;
        private final String mediaType;
        private final Function<Map<String, ?>, ? extends AbstractMedia<?>> parser;

        private MediaType(String mediaType, Function<Map<String, ?>, ? extends AbstractMedia<?>> parser) {
            this.mediaType = mediaType;
            this.parser = parser;
        }

        public String mediaType() {
            return this.mediaType;
        }

        AbstractMedia<?> parse(Map<String, ?> map) {
            return this.parser.apply(map);
        }

        static {
            PARSER = new EnumParser<MediaType>(MediaType.class, MediaType::mediaType);
        }
    }
}

