/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.ex.node.LayoutSectionException;
import com.atlassian.adf.model.mark.Breakout;
import com.atlassian.adf.model.mark.type.LayoutSectionMark;
import com.atlassian.adf.model.node.AbstractMarkedContentNode;
import com.atlassian.adf.model.node.LayoutColumn;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class LayoutSection
extends AbstractMarkedContentNode<LayoutSection, LayoutColumn, LayoutSectionMark>
implements DocContent {
    public static final int MINIMUM_LAYOUT_COLUMN_COUNT = 1;
    public static final int MAXIMUM_LAYOUT_COLUMN_COUNT = 5;
    static final Factory<LayoutSection> FACTORY = new Factory<LayoutSection>("layoutSection", LayoutSection.class, LayoutSection::parse);

    private LayoutSection() {
    }

    @Deprecated(forRemoval=true)
    public static Partial.NeedsFirstColumn layoutSection() {
        return new Partial.NeedsFirstColumn();
    }

    public static LayoutSection layoutSection(LayoutColumn col1) {
        return (LayoutSection)new LayoutSection().content(col1);
    }

    public static LayoutSection layoutSection(LayoutColumn col1, LayoutColumn col2) {
        return (LayoutSection)new LayoutSection().content(new LayoutColumn[]{col1, col2});
    }

    public static LayoutSection layoutSection(LayoutColumn col1, LayoutColumn col2, LayoutColumn col3) {
        return (LayoutSection)new LayoutSection().content(new LayoutColumn[]{col1, col2, col3});
    }

    public static LayoutSection layoutSection(LayoutColumn col1, LayoutColumn col2, LayoutColumn col3, LayoutColumn col4) {
        return (LayoutSection)new LayoutSection().content(new LayoutColumn[]{col1, col2, col3, col4});
    }

    public static LayoutSection layoutSection(LayoutColumn col1, LayoutColumn col2, LayoutColumn col3, LayoutColumn col4, LayoutColumn col5) {
        return (LayoutSection)new LayoutSection().content(new LayoutColumn[]{col1, col2, col3, col4, col5});
    }

    @Override
    public Class<LayoutColumn> contentClass() {
        return LayoutColumn.class;
    }

    @Override
    public LayoutSection copy() {
        return LayoutSection.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "layoutSection";
    }

    public Optional<Breakout> breakout() {
        return this.marks.stream(Breakout.class).findAny();
    }

    public LayoutSection breakout(@Nullable Breakout breakout) {
        this.marks.clear();
        if (breakout != null) {
            this.marks.add(breakout);
        }
        return this;
    }

    public LayoutSection wide() {
        return this.breakout(Breakout.wide());
    }

    public LayoutSection fullWidth() {
        return this.breakout(Breakout.fullWidth());
    }

    public LayoutSection defaultWidth() {
        return this.breakout(null);
    }

    @Override
    protected void validateContentNodeForAppend(LayoutColumn node) {
        if (this.content.size() >= 5) {
            throw new LayoutSectionException.TooManyLayoutColumns(6);
        }
    }

    @Override
    public Class<LayoutSectionMark> markClass() {
        return LayoutSectionMark.class;
    }

    @Override
    protected void markedContentNodeValidate() {
        this.requireTwoOrThreeColumns();
    }

    private void requireTwoOrThreeColumns() {
        int count = this.content.size();
        if (count < 1) {
            throw new LayoutSectionException.NotEnoughLayoutColumns(count);
        }
        if (count > 5) {
            throw new LayoutSectionException.TooManyLayoutColumns(count);
        }
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireTwoOrThreeColumns();
        return this.mapWithType().let(this::addContent).let(this.marks::addToMap);
    }

    private static LayoutSection parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "layoutSection");
        LayoutSection layoutSection = (LayoutSection)new LayoutSection().parseOptionalContent(map, LayoutColumn.class);
        layoutSection.requireTwoOrThreeColumns();
        return (LayoutSection)layoutSection.parseMarks(map);
    }

    @Deprecated(forRemoval=true)
    public static interface Partial {

        @Deprecated(forRemoval=true)
        public static class NeedsSecondColumn {
            private final LayoutColumn col1;

            NeedsSecondColumn(LayoutColumn col1) {
                this.col1 = Objects.requireNonNull(col1, "col1");
            }

            public LayoutSection content(LayoutColumn col2) {
                return LayoutSection.layoutSection(this.col1, col2);
            }

            public LayoutSection content(LayoutColumn col2, LayoutColumn col3) {
                return LayoutSection.layoutSection(this.col1, col2, col3);
            }
        }

        @Deprecated(forRemoval=true)
        public static class NeedsFirstColumn {
            NeedsFirstColumn() {
            }

            @Deprecated(forRemoval=true)
            public NeedsSecondColumn content(LayoutColumn col1) {
                return new NeedsSecondColumn(col1);
            }

            public LayoutSection content(LayoutColumn col1, LayoutColumn col2) {
                return LayoutSection.layoutSection(col1, col2);
            }

            public LayoutSection content(LayoutColumn col1, LayoutColumn col2, LayoutColumn col3) {
                return LayoutSection.layoutSection(col1, col2, col3);
            }

            public LayoutSection content(LayoutColumn col1, LayoutColumn col2, LayoutColumn col3, LayoutColumn col4) {
                return LayoutSection.layoutSection(col1, col2, col3, col4);
            }

            public LayoutSection content(LayoutColumn col1, LayoutColumn col2, LayoutColumn col3, LayoutColumn col4, LayoutColumn col5) {
                return LayoutSection.layoutSection(col1, col2, col3, col4, col5);
            }
        }
    }
}

