/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.mark.type.InlineExtensionMark;
import com.atlassian.adf.model.node.AbstractMarkedNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.ExtensionSettings;
import com.atlassian.adf.model.node.type.ExtensionNode;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.model.node.unsupported.UnsupportedNode;
import com.atlassian.adf.util.Factory;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class InlineExtension
extends AbstractMarkedNode<InlineExtension, InlineExtensionMark>
implements ExtensionNode<InlineExtension, InlineExtensionMark>,
InlineContent {
    static final Factory<InlineExtension> FACTORY = new Factory<InlineExtension>("inlineExtension", InlineExtension.class, InlineExtension::parse);
    private final ExtensionSettings settings;

    private InlineExtension(ExtensionSettings settings) {
        this.settings = settings;
    }

    @CheckReturnValue
    public static ExtensionSettings.Partial.NeedsExtensionKey<InlineExtension> inlineExtension() {
        return new ExtensionSettings.Partial.NeedsExtensionKey<InlineExtension>(InlineExtension::new);
    }

    public static InlineExtension inlineExtension(String extensionKey, String extensionType) {
        return ExtensionSettings.extensionSettings(InlineExtension::new).extensionKey(extensionKey).extensionType(extensionType);
    }

    @Override
    public InlineExtension copy() {
        return InlineExtension.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "inlineExtension";
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", this.settings.toExtensionAttrs()).let(this.marks::addToMap);
    }

    @Override
    public Class<InlineExtensionMark> markClass() {
        return InlineExtensionMark.class;
    }

    @Override
    protected int markedNodeHashCode() {
        return this.settings.hashCode();
    }

    @Override
    protected boolean markedNodeEquals(InlineExtension other) {
        return this.settings.equals(other.settings);
    }

    @Override
    protected void appendMarkedNodeFields(AbstractNode.ToStringHelper buf) {
        this.settings.appendExtensionFields(buf);
    }

    @Override
    public String extensionKey() {
        return this.settings.extensionKey();
    }

    @Override
    public InlineExtension extensionKey(String extensionKey) {
        this.settings.extensionKey(extensionKey);
        return this;
    }

    @Override
    public String extensionType() {
        return this.settings.extensionType();
    }

    @Override
    public InlineExtension extensionType(String extensionType) {
        this.settings.extensionType(extensionType);
        return this;
    }

    @Override
    public InlineExtension localId(@Nullable String localId) {
        this.settings.localId(localId);
        return this;
    }

    @Override
    public Optional<String> localId() {
        return this.settings.localId();
    }

    @Override
    public InlineExtension text(@Nullable String text) {
        this.settings.text(text);
        return this;
    }

    @Override
    public Optional<String> text() {
        return this.settings.text();
    }

    @Override
    public InlineExtension parameters(@Nullable Map<String, ?> parameters) {
        this.settings.parameters(parameters);
        return this;
    }

    @Override
    public Optional<Map<String, ?>> parameters() {
        return this.settings.parameters();
    }

    private static InlineExtension parse(Map<String, ?> map) {
        ExtensionSettings settings = ExtensionSettings.parse(map);
        return (InlineExtension)new InlineExtension(settings).parseMarks(map);
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        String text = this.settings.text().orElseGet(() -> UnsupportedNode.plainTextFallback(this));
        sb.append(text);
    }
}

