/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.ex.node.CardException;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.CaptionContent;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.model.node.unsupported.UnsupportedNode;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.Fold2;
import com.atlassian.adf.util.ParserSupport;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.REVIEWED, date="2023-07-26")
public class InlineCard
extends AbstractNode<InlineCard>
implements CaptionContent,
InlineContent {
    static Factory<InlineCard> FACTORY = new Factory<InlineCard>("inlineCard", InlineCard.class, InlineCard::parse);
    private final UrlOrData urlOrData;

    private InlineCard(UrlOrData urlOrData) {
        this.urlOrData = Objects.requireNonNull(urlOrData, "urlOrData");
    }

    @CheckReturnValue
    public static Partial.NeedsUrlOrData inlineCard() {
        return new Partial.NeedsUrlOrData();
    }

    public static InlineCard inlineCard(String url) {
        return InlineCard.inlineCard().url(url);
    }

    public static InlineCard inlineCard(URL url) {
        return InlineCard.inlineCard().url(url);
    }

    public static InlineCard inlineCard(URI url) {
        return InlineCard.inlineCard().url(url);
    }

    public static InlineCard inlineCard(Map<String, ?> data) {
        return InlineCard.inlineCard().data(data);
    }

    @Override
    public InlineCard copy() {
        return InlineCard.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "inlineCard";
    }

    @Override
    public void validate() {
    }

    @Override
    protected final boolean nodeEquals(InlineCard other) {
        return this.urlOrData.equals(other.urlOrData());
    }

    @Override
    protected final int nodeHashCode() {
        return this.urlOrData.hashCode();
    }

    @Override
    protected final void appendNodeFields(AbstractNode.ToStringHelper buf) {
        this.urlOrData.accept((Consumer<? super String>)((Consumer<String>)url -> buf.appendField("url", url)), (Consumer<? super Map<String, ?>>)((Consumer<Map>)data -> buf.appendField("data", data)));
    }

    @Override
    public final Map<String, ?> toMap() {
        return FieldMap.map("type", this.elementType(), "attrs", this.urlOrData().fold(url -> FieldMap.map("url", url), data -> FieldMap.map("data", FieldMap.map().addAll((Map<String, ?>)data))));
    }

    public UrlOrData urlOrData() {
        return this.urlOrData;
    }

    private static InlineCard parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "inlineCard");
        return new InlineCard(InlineCard.parseUrlOrData(map));
    }

    private static UrlOrData parseUrlOrData(Map<String, ?> map) {
        String url = ParserSupport.getAttr(map, "url", String.class).orElse(null);
        Map data = (Map)Cast.unsafeCast(ParserSupport.getAttr(map, "data", Map.class).orElse(null));
        if (url != null) {
            if (data != null) {
                throw new CardException.UrlAndDataCannotBothBeSet();
            }
            return new UrlImpl(url);
        }
        if (data == null) {
            throw new CardException.UrlOrDataMustBeSet();
        }
        return new DataImpl(data);
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        String text = this.urlOrData().fold(url -> url, data -> {
            Object url = data.get("url");
            return url != null ? url.toString() : UnsupportedNode.plainTextFallback(this);
        });
        sb.append(text);
    }

    public static interface UrlOrData
    extends Fold2<String, Map<String, ?>> {
        @Override
        public <T> T fold(Function<? super String, ? extends T> var1, Function<? super Map<String, ?>, ? extends T> var2);

        @Override
        public void accept(Consumer<? super String> var1, Consumer<? super Map<String, ?>> var2);

        public Optional<String> url();

        public Optional<Map<String, ?>> data();
    }

    public static interface Partial {

        public static class NeedsUrlOrData {
            NeedsUrlOrData() {
            }

            public InlineCard url(String url) {
                String cleanUrl = ParserSupport.cleanUri(url, "url");
                return new InlineCard(new UrlImpl(cleanUrl));
            }

            public InlineCard url(URL url) {
                String cleanUrl = ParserSupport.cleanUri(url, "url");
                return new InlineCard(new UrlImpl(cleanUrl));
            }

            public InlineCard url(URI url) {
                String cleanUrl = ParserSupport.cleanUri(url, "url");
                return new InlineCard(new UrlImpl(cleanUrl));
            }

            public InlineCard data(Map<String, ?> data) {
                return new InlineCard(new DataImpl(data));
            }
        }
    }

    private static class UrlImpl
    implements UrlOrData {
        private final String url;

        private UrlImpl(String url) {
            this.url = Objects.requireNonNull(url, "url");
        }

        @Override
        public <T> T fold(Function<? super String, ? extends T> ifUrl, Function<? super Map<String, ?>, ? extends T> ifData) {
            return ifUrl.apply(this.url);
        }

        @Override
        public void accept(Consumer<? super String> ifUrl, Consumer<? super Map<String, ?>> ifData) {
            ifUrl.accept(this.url);
        }

        @Override
        public Optional<String> url() {
            return Optional.of(this.url);
        }

        @Override
        public Optional<Map<String, ?>> data() {
            return Optional.empty();
        }

        public boolean equals(@Nullable Object o) {
            return this == o || o instanceof UrlImpl && ((UrlImpl)o).url.equals(this.url);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.url.hashCode();
        }

        public String toString() {
            return "UrlImpl{url=" + this.url + "}";
        }
    }

    private static class DataImpl
    implements UrlOrData {
        private final Map<String, ?> data;

        DataImpl(Map<String, ?> data) {
            Objects.requireNonNull(data, "data");
            this.data = new LinkedHashMap(data);
        }

        @Override
        public <T> T fold(Function<? super String, ? extends T> ifUrl, Function<? super Map<String, ?>, ? extends T> ifData) {
            return ifData.apply(this.data);
        }

        @Override
        public void accept(Consumer<? super String> ifUrl, Consumer<? super Map<String, ?>> ifData) {
            ifData.accept(this.data);
        }

        @Override
        public Optional<String> url() {
            return Optional.empty();
        }

        @Override
        public Optional<Map<String, ?>> data() {
            return Optional.of(this.data);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof DataImpl && ((DataImpl)o).data.equals(this.data);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.data.hashCode();
        }

        public String toString() {
            return "DataImpl{data=" + String.valueOf(this.data) + "}";
        }
    }
}

