/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.ex.node;

import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.node.Node;
import java.util.Objects;

public abstract class NodeException
extends AdfException {
    private static final long serialVersionUID = 1L;

    NodeException(String message) {
        super(message);
    }

    public static class TypeMismatch
    extends NodeException {
        private static final long serialVersionUID = 1L;
        private final String parentType;
        private final Class<? extends Node> requiredClass;
        private final String type;

        public TypeMismatch(String parentType, Class<? extends Node> requiredClass, String type) {
            super("incorrect node type for this context: parentType=" + parentType + "; required=" + requiredClass.getSimpleName() + "; type=" + type);
            this.parentType = parentType;
            this.requiredClass = Objects.requireNonNull(requiredClass, "requiredClass");
            this.type = Objects.requireNonNull(type, "type");
        }

        public String parentType() {
            return this.parentType;
        }

        public Class<? extends Node> requiredClass() {
            return this.requiredClass;
        }

        public String type() {
            return this.type;
        }
    }
}

