/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.ctx;

import com.atlassian.adf.ctx.Context;
import java.util.function.Supplier;

public enum Feature {
    PLAINTEXT_MENTION_USE_ID,
    PARSE_ENABLE_REPAIRS;

    private final boolean defaultToEnabled;

    private Feature() {
        this(false);
    }

    private Feature(boolean defaultToEnabled) {
        this.defaultToEnabled = defaultToEnabled;
    }

    public boolean defaultToEnabled() {
        return this.defaultToEnabled;
    }

    public boolean enabled() {
        return Context.current().featureProvider().enabled(this);
    }

    public <T> T get(Supplier<T> ifEnabled, Supplier<T> ifDisabled) {
        Supplier<T> supplier = this.enabled() ? ifEnabled : ifDisabled;
        return supplier.get();
    }

    public void run(Runnable ifEnabled, Runnable ifDisabled) {
        Runnable effect = this.enabled() ? ifEnabled : ifDisabled;
        effect.run();
    }

    public Feature ifEnabled(Runnable ifEnabled) {
        if (this.enabled()) {
            ifEnabled.run();
        }
        return this;
    }

    public Feature ifDisabled(Runnable ifDisabled) {
        if (!this.enabled()) {
            ifDisabled.run();
        }
        return this;
    }
}

