/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.LocalIdRequired;
import com.atlassian.adf.model.mark.Breakout;
import com.atlassian.adf.model.mark.MarkKey;
import com.atlassian.adf.model.mark.type.SyncBlockMark;
import com.atlassian.adf.model.node.AbstractMarkedNode;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class SyncBlock
extends AbstractMarkedNode<SyncBlock, SyncBlockMark>
implements LocalIdRequired<SyncBlock>,
DocContent {
    static final Factory<SyncBlock> FACTORY = new Factory<SyncBlock>("syncBlock", SyncBlock.class, SyncBlock::parse);
    private String localId;
    private String resourceId;

    private SyncBlock(String localId, String resourceId) {
        this.localId = Objects.requireNonNull(localId, "localId");
        this.resourceId = Objects.requireNonNull(resourceId, "resourceId");
    }

    public static Partial.NeedsLocalIdAndResourceId syncBlock() {
        return new Partial.NeedsLocalIdAndResourceId();
    }

    @Override
    public String localId() {
        return this.localId;
    }

    @Override
    public SyncBlock localId(String localId) {
        this.localId = Objects.requireNonNull(localId, "localId");
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public SyncBlock resourceId(String resourceId) {
        this.resourceId = Objects.requireNonNull(resourceId, "resourceId");
        return this;
    }

    @Override
    public String elementType() {
        return "syncBlock";
    }

    @Override
    public SyncBlock copy() {
        return SyncBlock.parse(this.toMap());
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map().add("localId", this.localId).add("resourceId", this.resourceId)).let(this.marks::addToMap);
    }

    private static SyncBlock parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "syncBlock");
        String localId = LocalIdRequired.parseLocalId(map);
        String resourceId = (String)ParserSupport.getAttrOrThrow(map, "resourceId");
        SyncBlock syncBlock = new Partial.NeedsLocalIdAndResourceId().localId(localId).resourceId(resourceId);
        return (SyncBlock)syncBlock.parseMarks(map);
    }

    @Override
    public Class<SyncBlockMark> markClass() {
        return SyncBlockMark.class;
    }

    @Override
    protected boolean markedNodeEquals(SyncBlock other) {
        return this.resourceId.equals(other.resourceId) && this.localId.equals(other.localId);
    }

    @Override
    protected int markedNodeHashCode() {
        return Objects.hash(this.resourceId, this.localId);
    }

    public Optional<Breakout> breakout() {
        return this.marks.get(MarkKey.breakout()).map(Breakout.class::cast);
    }

    public SyncBlock breakout(@Nullable Breakout breakout) {
        this.marks.clear();
        if (breakout != null) {
            this.marks.add(breakout);
        }
        return this;
    }

    public SyncBlock wide() {
        return this.breakout(Breakout.wide());
    }

    public SyncBlock fullWidth() {
        return this.breakout(Breakout.fullWidth());
    }

    public SyncBlock defaultWidth() {
        return this.breakout(null);
    }

    public static interface Partial {

        public static class NeedsLocalIdAndResourceId {
            NeedsLocalIdAndResourceId() {
            }

            public NeedsResourceId localId(String localId) {
                return new NeedsResourceId(localId);
            }

            public NeedsLocalId resourceId(String resourceId) {
                return new NeedsLocalId(resourceId);
            }
        }

        public static class NeedsLocalId {
            private final String resourceId;

            NeedsLocalId(String resourceId) {
                this.resourceId = Objects.requireNonNull(resourceId, "resourceId");
            }

            public SyncBlock localId(String localId) {
                return new SyncBlock(Objects.requireNonNull(localId, "localId"), this.resourceId);
            }
        }

        public static class NeedsResourceId {
            private final String localId;

            NeedsResourceId(String localId) {
                this.localId = Objects.requireNonNull(localId, "localId");
            }

            public SyncBlock resourceId(String resourceId) {
                return new SyncBlock(this.localId, Objects.requireNonNull(resourceId, "resourceId"));
            }
        }
    }
}

