/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.LocalIdOptional;
import com.atlassian.adf.model.mark.Breakout;
import com.atlassian.adf.model.mark.MarkKey;
import com.atlassian.adf.model.mark.type.CodeBlockMark;
import com.atlassian.adf.model.node.AbstractMarkedContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.model.node.type.BlockquoteContent;
import com.atlassian.adf.model.node.type.BodiedSyncBlockContent;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.ExtensionFrameContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.ListItemContent;
import com.atlassian.adf.model.node.type.NestedExpandContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.PanelContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.util.Char;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.REVIEWED, date="2023-07-26")
public class CodeBlock
extends AbstractMarkedContentNode<CodeBlock, Text, CodeBlockMark>
implements LocalIdOptional<CodeBlock>,
BlockquoteContent,
BodiedSyncBlockContent,
DocContent,
ExtensionFrameContent,
LayoutColumnContent,
ListItemContent,
NestedExpandContent,
NonNestableBlockContent,
PanelContent,
TableCellContent {
    static final Factory<CodeBlock> FACTORY = new Factory<CodeBlock>("codeBlock", CodeBlock.class, CodeBlock::parse);
    @Nullable
    private String language;
    @Nullable
    private String localId;
    @Nullable
    private String uniqueId;

    private CodeBlock() {
    }

    public static CodeBlock codeBlock() {
        return new CodeBlock();
    }

    public static CodeBlock codeBlock(String content) {
        return (CodeBlock)CodeBlock.codeBlock().content(Text.text(content));
    }

    public static CodeBlock codeBlock(String ... content) {
        return (CodeBlock)CodeBlock.codeBlock().content(Text.text(content));
    }

    public static CodeBlock codeBlock(Text content) {
        return (CodeBlock)CodeBlock.codeBlock().content(content);
    }

    public static CodeBlock codeBlock(Text ... content) {
        return (CodeBlock)CodeBlock.codeBlock().content(content);
    }

    public static CodeBlock codeBlock(Iterable<? extends Text> content) {
        return (CodeBlock)CodeBlock.codeBlock().content(content);
    }

    public static CodeBlock codeBlock(Stream<? extends Text> content) {
        return (CodeBlock)CodeBlock.codeBlock().content(content);
    }

    public static CodeBlock pre() {
        return new CodeBlock();
    }

    public static CodeBlock pre(String content) {
        return (CodeBlock)CodeBlock.pre().content(Text.text(content));
    }

    public static CodeBlock pre(String ... content) {
        return (CodeBlock)CodeBlock.pre().content(Text.text(content));
    }

    public static CodeBlock pre(Text content) {
        return (CodeBlock)CodeBlock.pre().content(content);
    }

    public static CodeBlock pre(Text ... content) {
        return (CodeBlock)CodeBlock.pre().content(content);
    }

    public static CodeBlock pre(Iterable<? extends Text> content) {
        return (CodeBlock)CodeBlock.pre().content(content);
    }

    public static CodeBlock pre(Stream<? extends Text> content) {
        return (CodeBlock)CodeBlock.pre().content(content);
    }

    @Override
    public CodeBlock copy() {
        return CodeBlock.parse(this.toMap());
    }

    @Override
    public CodeBlock content(String content) {
        return (CodeBlock)this.content(Text.text(content));
    }

    @Override
    public CodeBlock content(String ... content) {
        return (CodeBlock)this.content(Text.text(content));
    }

    @Override
    public CodeBlock localId(@Nullable String localId) {
        this.localId = localId;
        return this;
    }

    @Override
    public Optional<String> localId() {
        return Optional.ofNullable(this.localId);
    }

    public Optional<String> language() {
        return Optional.ofNullable(this.language);
    }

    public CodeBlock language(@Nullable String language) {
        this.language = language;
        return this;
    }

    public Optional<String> uniqueId() {
        return Optional.ofNullable(this.uniqueId);
    }

    public CodeBlock uniqueId(@Nullable String uniqueId) {
        this.uniqueId = uniqueId;
        return this;
    }

    public Optional<Breakout> breakout() {
        return this.marks.get(MarkKey.breakout()).map(Breakout.class::cast);
    }

    public CodeBlock breakout(@Nullable Breakout breakout) {
        this.marks.clear();
        if (breakout != null) {
            this.marks.add(breakout);
        }
        return this;
    }

    public CodeBlock wide() {
        return this.breakout(Breakout.wide());
    }

    public CodeBlock fullWidth() {
        return this.breakout(Breakout.fullWidth());
    }

    public CodeBlock defaultWidth() {
        return this.breakout(null);
    }

    public CodeBlock trim() {
        this.trimLeadingSpaces();
        this.trimTrailingSpaces();
        return this;
    }

    @Override
    protected void validateContentNodeForAppend(Text node) {
        super.validateContentNodeForAppend(node);
        node.disableMarks(this);
    }

    @Override
    public Class<Text> contentClass() {
        return Text.class;
    }

    @Override
    public String elementType() {
        return "codeBlock";
    }

    @Override
    public Map<String, ?> toMap() {
        FieldMap attrs = FieldMap.map().addIfPresent("language", this.language).addIfPresent("localId", this.localId).addIfPresent("uniqueId", this.uniqueId);
        return this.mapWithType().addIf(!attrs.isEmpty(), "attrs", () -> attrs).let(this::addContentIfPresent).let(this.marks::addToMap);
    }

    private static CodeBlock parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "codeBlock");
        CodeBlock pre = (CodeBlock)CodeBlock.pre().parseOptionalContent(map, Text.class);
        ParserSupport.getAttr(map, "language", String.class).ifPresent(pre::language);
        ParserSupport.getAttr(map, "uniqueId", String.class).ifPresent(pre::uniqueId);
        LocalIdOptional.parseLocalId(pre, map);
        return (CodeBlock)pre.parseMarks(map);
    }

    @Override
    public Class<CodeBlockMark> markClass() {
        return CodeBlockMark.class;
    }

    @Override
    protected boolean markedContentNodeEquals(CodeBlock other) {
        return Objects.equals(this.language, other.language) && Objects.equals(this.localId, other.localId) && Objects.equals(this.uniqueId, other.uniqueId);
    }

    @Override
    protected int markedContentNodeHashCode() {
        return Objects.hash(this.language, this.localId, this.uniqueId);
    }

    @Override
    protected void appendMarkedContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("language", this.language);
        buf.appendField("localId", this.localId);
        buf.appendField("uniqueId", this.uniqueId);
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        this.appendPlainTextInlineContent(sb);
    }

    void disableMarks(ContentNode<?, ? super CodeBlock> parent) {
        this.marks.disable(parent.elementType());
    }

    private void trimLeadingSpaces() {
        while (!this.content.isEmpty()) {
            Text text = (Text)this.content.get(0);
            String codeText = text.text();
            int index = CodeBlock.findFirstNonSpaceIndex(codeText);
            if (index == -1) {
                this.content.remove(0);
                continue;
            }
            if (index <= 0) break;
            text.set(codeText.substring(index));
            break;
        }
    }

    private void trimTrailingSpaces() {
        while (!this.content.isEmpty()) {
            Text text = (Text)this.content.get(this.content.size() - 1);
            String contentText = text.text();
            int index = CodeBlock.findLastNonSpaceIndex(contentText);
            if (index == -1) {
                this.content.remove(this.content.size() - 1);
                continue;
            }
            if (index >= contentText.length() - 1) break;
            text.set(text.text().substring(0, index + 1));
            break;
        }
    }

    private static int findFirstNonSpaceIndex(String codeText) {
        for (int index = 0; index < codeText.length(); ++index) {
            if (!CodeBlock.isNonSpace(codeText, index)) continue;
            return index;
        }
        return -1;
    }

    private static int findLastNonSpaceIndex(String codeText) {
        for (int index = codeText.length() - 1; index >= 0; --index) {
            if (!CodeBlock.isNonSpace(codeText, index)) continue;
            return index;
        }
        return -1;
    }

    private static boolean isNonSpace(String codeText, int index) {
        return !Char.isSpace(codeText.charAt(index)) && !Char.isNonBreakingSpace(codeText.charAt(index));
    }
}

