/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.LocalIdOptional;
import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.ex.node.CardException;
import com.atlassian.adf.model.ex.node.MediaException;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.RichMedia;
import com.atlassian.adf.model.node.type.BodiedSyncBlockContent;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.ExtensionFrameContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.PanelContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.Fold3;
import com.atlassian.adf.util.ParserSupport;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class BlockCard
extends AbstractNode<BlockCard>
implements LocalIdOptional<BlockCard>,
BodiedSyncBlockContent,
DocContent,
ExtensionFrameContent,
LayoutColumnContent,
NonNestableBlockContent,
PanelContent,
TableCellContent {
    static final Factory<BlockCard> FACTORY = new Factory<BlockCard>("blockCard", BlockCard.class, BlockCard::parse);
    private final CardAttributes cardAttributes;
    @Nullable
    private String localId;

    private BlockCard(CardAttributes cardAttributes) {
        this.cardAttributes = Objects.requireNonNull(cardAttributes, "cardAttributes");
    }

    @CheckReturnValue
    public static Partial.NeedsCardAttributes blockCard() {
        return new Partial.NeedsCardAttributes();
    }

    public static BlockCard blockCard(String url) {
        return BlockCard.blockCard().url(url);
    }

    public static BlockCard blockCard(URL url) {
        return BlockCard.blockCard().url(url);
    }

    public static BlockCard blockCard(URI url) {
        return BlockCard.blockCard().url(url);
    }

    public static BlockCard blockCard(Map<String, ?> data) {
        return BlockCard.blockCard().data(data);
    }

    @Override
    public BlockCard localId(@Nullable String localId) {
        this.localId = localId;
        return this;
    }

    @Override
    public Optional<String> localId() {
        return Optional.ofNullable(this.localId);
    }

    @Override
    public BlockCard copy() {
        return BlockCard.parse(this.toMap());
    }

    @Override
    public void validate() {
    }

    @Override
    public String elementType() {
        return "blockCard";
    }

    @Override
    protected final boolean nodeEquals(BlockCard other) {
        return this.cardAttributes.equals(other.cardAttributes()) && Objects.equals(this.localId, other.localId);
    }

    @Override
    protected final int nodeHashCode() {
        return Objects.hash(this.cardAttributes, this.localId);
    }

    @Override
    protected final void appendNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("localId", this.localId);
        this.cardAttributes.accept((Consumer<? super String>)((Consumer<String>)url -> buf.appendField("url", url)), (Consumer<? super Map<String, ?>>)((Consumer<Map>)data -> buf.appendField("data", data)), (Consumer<? super Datasource>)((Consumer<Datasource>)datasource -> buf.appendField("datasource", datasource)));
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
    }

    @Override
    public final Map<String, ?> toMap() {
        return FieldMap.map("type", this.elementType(), "attrs", this.cardAttributes.toAttributesMap().addIfPresent("localId", this.localId));
    }

    public CardAttributes cardAttributes() {
        return this.cardAttributes;
    }

    private static BlockCard parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "blockCard");
        CardAttributes cardAttributes = BlockCard.parseCardAttributes(map);
        BlockCard blockCard = new BlockCard(cardAttributes);
        LocalIdOptional.parseLocalId(blockCard, map);
        return blockCard;
    }

    private static CardAttributes parseCardAttributes(Map<String, ?> map) {
        String url = ParserSupport.getAttr(map, "url", String.class).orElse(null);
        Map data = (Map)Cast.unsafeCast(ParserSupport.getAttr(map, "data", Map.class).orElse(null));
        Map datasource = (Map)Cast.unsafeCast(ParserSupport.getAttr(map, "datasource", Map.class).orElse(null));
        if (data != null) {
            if (datasource != null) {
                throw new CardException.DataAndDatasourceCannotBothBeSet();
            }
            if (url != null) {
                throw new CardException.UrlAndDataCannotBothBeSet();
            }
            return new DataImpl(data);
        }
        if (datasource != null) {
            return Datasource.parseDatasource(map, datasource);
        }
        if (url != null) {
            return new UrlImpl(url);
        }
        throw new CardException.BlockCardAttributesMustBeSet();
    }

    public static abstract class CardAttributes
    implements Fold3<String, Map<String, ?>, Datasource> {
        @Override
        public abstract <T> T fold(Function<? super String, ? extends T> var1, Function<? super Map<String, ?>, ? extends T> var2, Function<? super Datasource, ? extends T> var3);

        @Override
        public abstract void accept(Consumer<? super String> var1, Consumer<? super Map<String, ?>> var2, Consumer<? super Datasource> var3);

        abstract FieldMap toAttributesMap();
    }

    public static interface Partial {

        public static class NeedsDatasourceViews
        extends OptionalDatasourceParameters<NeedsDatasourceViews> {
            final String id;
            private final Map<String, ?> parameters;

            public NeedsDatasourceViews(NeedsDatasourceParameters source, Map<String, ?> parameters) {
                super(source);
                this.id = source.id;
                this.parameters = parameters;
            }

            public BlockCard views(View ... views) {
                return this.views(List.of(views));
            }

            public BlockCard views(List<View> views) {
                Datasource datasource = new Datasource(this.url, this.id, this.parameters, List.copyOf(views)).width(this.width).layout(this.layout);
                return new BlockCard(datasource);
            }
        }

        public static class NeedsDatasourceParameters
        extends OptionalDatasourceParameters<NeedsDatasourceParameters> {
            final String id;

            NeedsDatasourceParameters(NeedsDatasourceId source, String id) {
                super(source);
                this.id = Objects.requireNonNull(id, "id");
            }

            @CheckReturnValue
            public NeedsDatasourceViews parameters(Map<String, ?> parameters) {
                return new NeedsDatasourceViews(this, FieldMap.immutableCopy(parameters));
            }
        }

        public static class NeedsDatasourceId
        extends OptionalDatasourceParameters<NeedsDatasourceId> {
            NeedsDatasourceId() {
            }

            @CheckReturnValue
            public NeedsDatasourceParameters id(String id) {
                return new NeedsDatasourceParameters(this, id);
            }
        }

        public static class OptionalDatasourceParameters<T extends OptionalDatasourceParameters<T>> {
            @Nullable
            String url;
            @Nullable
            Number width;
            @Nullable
            RichMedia.Layout layout;

            OptionalDatasourceParameters() {
            }

            OptionalDatasourceParameters(OptionalDatasourceParameters<?> source) {
                this.url = source.url;
                this.width = source.width;
                this.layout = source.layout;
            }

            @CheckReturnValue
            public T url(@Nullable String url) {
                this.url = url != null ? ParserSupport.cleanUri(url, "url") : null;
                return this.self();
            }

            @CheckReturnValue
            public T url(@Nullable URL url) {
                this.url = url != null ? ParserSupport.cleanUri(url, "url") : null;
                return this.self();
            }

            @CheckReturnValue
            public T url(@Nullable URI url) {
                this.url = url != null ? ParserSupport.cleanUri(url, "url") : null;
                return this.self();
            }

            @CheckReturnValue
            public T width(@Nullable Number width) {
                this.width = width != null ? (Number)Datasource.validateWidth(width) : (Number)null;
                return this.self();
            }

            @CheckReturnValue
            public T layout(@Nullable String layout) {
                return this.layout(RichMedia.Layout.PARSER.parseAllowNull(layout));
            }

            @CheckReturnValue
            public T layout(@Nullable RichMedia.Layout layout) {
                this.layout = layout;
                return this.self();
            }

            private T self() {
                return (T)((OptionalDatasourceParameters)Cast.unsafeCast(this));
            }
        }

        public static class NeedsCardAttributes {
            NeedsCardAttributes() {
            }

            public BlockCard url(String url) {
                String cleanUrl = ParserSupport.cleanUri(url, "url");
                return new BlockCard(new UrlImpl(cleanUrl));
            }

            public BlockCard url(URL url) {
                String cleanUrl = ParserSupport.cleanUri(url, "url");
                return new BlockCard(new UrlImpl(cleanUrl));
            }

            public BlockCard url(URI url) {
                String cleanUrl = ParserSupport.cleanUri(url, "url");
                return new BlockCard(new UrlImpl(cleanUrl));
            }

            public BlockCard data(Map<String, ?> data) {
                return new BlockCard(new DataImpl(data));
            }

            @CheckReturnValue
            public NeedsDatasourceId datasource() {
                return new NeedsDatasourceId();
            }
        }
    }

    private static class DataImpl
    extends CardAttributes {
        private final Map<String, ?> data;

        DataImpl(Map<String, ?> data) {
            Objects.requireNonNull(data, "data");
            this.data = new LinkedHashMap(data);
        }

        @Override
        public <T> T fold(Function<? super String, ? extends T> ifUrl, Function<? super Map<String, ?>, ? extends T> ifData, Function<? super Datasource, ? extends T> ifDatasource) {
            return ifData.apply(this.data);
        }

        @Override
        public void accept(Consumer<? super String> ifUrl, Consumer<? super Map<String, ?>> ifData, Consumer<? super Datasource> ifDatasource) {
            ifData.accept(this.data);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof DataImpl && ((DataImpl)o).data.equals(this.data);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.data.hashCode();
        }

        public String toString() {
            return "DataImpl{data=" + String.valueOf(this.data) + "}";
        }

        @Override
        FieldMap toAttributesMap() {
            return FieldMap.map("data", FieldMap.map().addAll(this.data));
        }
    }

    public static class Datasource
    extends CardAttributes {
        @Nullable
        private String url;
        @Nullable
        private Number width;
        @Nullable
        private RichMedia.Layout layout;
        private String id;
        private Map<String, ?> parameters;
        private List<View> views;

        Datasource(@Nullable String url, String id, Map<String, ?> parameters, List<View> views) {
            this.url = url;
            this.id = Objects.requireNonNull(id, "id");
            this.parameters = Objects.requireNonNull(parameters, "parameters");
            this.views = this.validateViews(views);
        }

        @Override
        public <T> T fold(Function<? super String, ? extends T> ifUrl, Function<? super Map<String, ?>, ? extends T> ifData, Function<? super Datasource, ? extends T> ifDatasource) {
            return ifDatasource.apply(this);
        }

        @Override
        public void accept(Consumer<? super String> ifUrl, Consumer<? super Map<String, ?>> ifData, Consumer<? super Datasource> ifDatasource) {
            ifDatasource.accept(this);
        }

        public Optional<String> url() {
            return Optional.ofNullable(this.url);
        }

        public Datasource url(@Nullable String url) {
            this.url = url != null ? ParserSupport.cleanUri(url, "url") : null;
            return this;
        }

        public Datasource url(@Nullable URL url) {
            this.url = url != null ? ParserSupport.cleanUri(url, "url") : null;
            return this;
        }

        public Datasource url(@Nullable URI url) {
            this.url = url != null ? ParserSupport.cleanUri(url, "url") : null;
            return this;
        }

        public Optional<Number> width() {
            return Optional.ofNullable(this.width);
        }

        public Datasource width(@Nullable Number width) {
            this.width = Datasource.validateWidth(width);
            return this;
        }

        public Optional<RichMedia.Layout> layout() {
            return Optional.ofNullable(this.layout);
        }

        public Datasource layout(@Nullable String layout) {
            return this.layout(RichMedia.Layout.PARSER.parseAllowNull(layout));
        }

        public Datasource layout(@Nullable RichMedia.Layout layout) {
            this.layout = layout;
            return this;
        }

        public String id() {
            return this.id;
        }

        public Datasource id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        public Map<String, ?> parameters() {
            return this.parameters;
        }

        public Datasource parameters(Map<String, ?> parameters) {
            this.parameters = FieldMap.immutableCopy(parameters);
            return this;
        }

        public List<View> views() {
            return List.copyOf(this.views);
        }

        public Datasource views(List<View> views) {
            this.views = this.validateViews(views);
            return this;
        }

        private List<View> validateViews(List<View> views) {
            Objects.requireNonNull(views, "views");
            if (views.isEmpty()) {
                throw new CardException.DatasourceRequiresAtLeastOneView();
            }
            return views;
        }

        @Nullable
        static Number validateWidth(@Nullable Number width) {
            if (width == null) {
                return null;
            }
            double widthDouble = width.doubleValue();
            if (widthDouble < 0.0 || widthDouble > 100.0) {
                throw new MediaException.WidthMustBeValidPercentage(width);
            }
            return width;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Datasource)) {
                return false;
            }
            Datasource other = (Datasource)o;
            return this.id.equals(other.id) && this.layout == other.layout && Objects.equals(this.url, other.url) && AbstractNode.numberEq(this.width, other.width) && this.parameters.equals(other.parameters) && this.views.equals(other.views);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.parameters, this.views, this.url, this.width, this.layout});
        }

        public String toString() {
            StringBuilder sb = new StringBuilder().append("Datasource[id=").append(this.id).append(",parameters=").append(this.parameters).append(",views=").append(this.views);
            if (this.url != null) {
                sb.append(",url=").append(this.url);
            }
            if (this.width != null) {
                sb.append(",width=").append(this.width);
            }
            if (this.layout != null) {
                sb.append(",layout=").append((Object)this.layout);
            }
            return sb.append('}').toString();
        }

        static Datasource parseDatasource(Map<String, ?> map, Map<String, ?> datasourceMap) {
            String id = (String)Cast.unsafeCast(datasourceMap.get("id"));
            if (id == null) {
                throw new AdfException.MissingProperty("datasource.id");
            }
            Map parameters = (Map)Cast.unsafeCast(datasourceMap.get("parameters"));
            if (parameters == null) {
                throw new AdfException.MissingProperty("datasource.parameters");
            }
            List viewMaps = (List)Cast.unsafeCast(datasourceMap.get("views"));
            List<View> views = View.parseViews(viewMaps);
            String url = ParserSupport.getAttr(map, "url", String.class).orElse(null);
            Number width = ParserSupport.getAttr(map, "width", Number.class).orElse(null);
            String layout = ParserSupport.getAttr(map, "layout", String.class).orElse(null);
            return new Datasource(url, id, FieldMap.immutableCopy(parameters), views).width(width).layout(layout);
        }

        @Override
        FieldMap toAttributesMap() {
            return FieldMap.map().addIfPresent("url", this.url).add("datasource", FieldMap.map().add("id", this.id).add("parameters", this.parameters).add("views", this.views.stream().map(View::toViewMap).collect(Collectors.toList()))).addIfPresent("width", this.width).addMappedIfPresent("layout", this.layout, RichMedia.Layout::layout);
        }

        static interface Attr {
            public static final String ID = "id";
            public static final String PARAMETERS = "parameters";
            public static final String VIEWS = "views";
        }
    }

    private static class UrlImpl
    extends CardAttributes {
        private final String url;

        private UrlImpl(String url) {
            this.url = Objects.requireNonNull(url, "url");
        }

        @Override
        public <T> T fold(Function<? super String, ? extends T> ifUrl, Function<? super Map<String, ?>, ? extends T> ifData, Function<? super Datasource, ? extends T> ifDatasource) {
            return ifUrl.apply(this.url);
        }

        @Override
        public void accept(Consumer<? super String> ifUrl, Consumer<? super Map<String, ?>> ifData, Consumer<? super Datasource> ifDatasource) {
            ifUrl.accept(this.url);
        }

        public boolean equals(@Nullable Object o) {
            return this == o || o instanceof UrlImpl && ((UrlImpl)o).url.equals(this.url);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.url.hashCode();
        }

        public String toString() {
            return "UrlImpl{url=" + this.url + "}";
        }

        @Override
        FieldMap toAttributesMap() {
            return FieldMap.map("url", this.url);
        }
    }

    public static class View {
        @Nullable
        private Map<String, ?> properties;
        private String type;

        View(String type, @Nullable Map<String, ?> properties) {
            this.type = Objects.requireNonNull(type, "type");
            this.properties = properties != null ? FieldMap.immutableCopy(properties) : null;
        }

        public static View view(String type) {
            return new View(type, null);
        }

        public String type() {
            return this.type;
        }

        public View type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        public Optional<Map<String, ?>> properties() {
            return Optional.ofNullable(this.properties);
        }

        public View properties(@Nullable Map<String, ?> properties) {
            this.properties = properties != null ? FieldMap.immutableCopy(properties) : null;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof View)) {
                return false;
            }
            View other = (View)o;
            return this.type.equals(other.type) && Objects.equals(this.properties, other.properties);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.properties);
        }

        public String toString() {
            return "View{type=" + this.type + ", properties=" + String.valueOf(this.properties) + "}";
        }

        Map<String, ?> toViewMap() {
            return FieldMap.map("type", this.type).addIfPresent("properties", this.properties);
        }

        static List<View> parseViews(@Nullable List<Map<String, ?>> viewMaps) {
            if (viewMaps == null || viewMaps.isEmpty()) {
                throw new CardException.DatasourceRequiresAtLeastOneView();
            }
            ArrayList<View> views = new ArrayList<View>(viewMaps.size());
            for (int i = 0; i < viewMaps.size(); ++i) {
                Map<String, ?> viewMap = viewMaps.get(i);
                String type = (String)Cast.unsafeCast(viewMap.get("type"));
                Map properties = (Map)Cast.unsafeCast(viewMap.get("properties"));
                if (type == null) {
                    throw new AdfException.MissingProperty("datasource.views[" + i + "].type");
                }
                views.add(new View(type, properties));
            }
            return views;
        }

        static interface Attr {
            public static final String PROPERTIES = "properties";
            public static final String TYPE = "type";
        }
    }
}

