/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.mark;

import com.atlassian.adf.model.mark.Mark;
import com.atlassian.adf.model.mark.MarkKey;
import com.atlassian.annotations.Internal;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Internal
class MarkKeys {
    private static final ConcurrentMap<Class<? extends Mark>, ClassMarkKey> CLASS_REGISTRY = new ConcurrentHashMap<Class<? extends Mark>, ClassMarkKey>();

    MarkKeys() {
    }

    static MarkKey byClass(Class<? extends Mark> markClass) {
        return CLASS_REGISTRY.computeIfAbsent(markClass, ClassMarkKey::new);
    }

    static MarkKey byClassAndId(Class<? extends Mark> markClass, Object id) {
        return new ClassAndIdMarkKey(markClass, id);
    }

    static MarkKey byValue(Mark mark) {
        return new ValueMarkKey(mark);
    }

    private static class ClassAndIdMarkKey
    implements MarkKey {
        private final Class<? extends Mark> owner;
        private final Object id;

        ClassAndIdMarkKey(Class<? extends Mark> owner, Object id) {
            this.owner = Objects.requireNonNull(owner, "owner");
            this.id = Objects.requireNonNull(id, "id");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassAndIdMarkKey)) {
                return false;
            }
            ClassAndIdMarkKey other = (ClassAndIdMarkKey)o;
            return this.owner == other.owner && this.id.equals(other.id);
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.id);
        }

        public String toString() {
            return "ClassAndIdMarkKey{owner=" + this.owner.getSimpleName() + ", id=" + String.valueOf(this.id) + "}";
        }
    }

    private static class ValueMarkKey
    implements MarkKey {
        private final Mark mark;

        ValueMarkKey(Mark mark) {
            this.mark = Objects.requireNonNull(mark, "mark");
        }

        public boolean equals(Object o) {
            return this == o || o instanceof ValueMarkKey && ((ValueMarkKey)o).mark.equals(this.mark);
        }

        public int hashCode() {
            return this.mark.hashCode();
        }

        public String toString() {
            return "ValueMarkKey{value=" + String.valueOf(this.mark) + "}";
        }
    }

    private static class ClassMarkKey
    implements MarkKey {
        private final Class<? extends Mark> owner;

        private ClassMarkKey(Class<? extends Mark> owner) {
            this.owner = owner;
        }

        public String toString() {
            return "ClassMarkKey{owner=" + this.owner.getSimpleName() + "}";
        }
    }
}

