/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.mark;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.mark.AbstractMark;
import com.atlassian.adf.model.mark.MarkKey;
import com.atlassian.adf.model.mark.MarkKeys;
import com.atlassian.adf.model.mark.type.CodeTextMark;
import com.atlassian.adf.model.mark.type.DateMark;
import com.atlassian.adf.model.mark.type.EmojiMark;
import com.atlassian.adf.model.mark.type.FormattedTextMark;
import com.atlassian.adf.model.mark.type.MediaInlineMark;
import com.atlassian.adf.model.mark.type.MediaMark;
import com.atlassian.adf.model.mark.type.MentionMark;
import com.atlassian.adf.model.mark.type.StatusMark;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class Annotation
extends AbstractMark
implements CodeTextMark,
DateMark,
EmojiMark,
FormattedTextMark,
MediaInlineMark,
MediaMark,
MentionMark,
StatusMark {
    static final Factory<Annotation> FACTORY = new Factory<Annotation>("annotation", Annotation.class, Annotation::parse);
    private final String id;
    private final AnnotationType annotationType;

    public Annotation(String id, AnnotationType annotationType) {
        this.id = Objects.requireNonNull(id, "id");
        this.annotationType = Objects.requireNonNull(annotationType, "annotationType");
    }

    public static Annotation annotation(String id, AnnotationType annotationType) {
        return new Annotation(id, annotationType);
    }

    public static Annotation inlineComment(String id) {
        return Annotation.annotation(id, AnnotationType.INLINE_COMMENT);
    }

    public String id() {
        return this.id;
    }

    public AnnotationType annotationType() {
        return this.annotationType;
    }

    @Override
    public Annotation copy() {
        return this;
    }

    @Override
    public String elementType() {
        return "annotation";
    }

    @Override
    public MarkKey markKey() {
        return MarkKeys.byValue(this);
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map("annotationType", this.annotationType.annotationType(), "id", this.id));
    }

    @Override
    public String toString() {
        return this.elementType() + "[id=" + this.id + ", annotationType=" + this.annotationType.annotationType() + "]";
    }

    public boolean equals(@Nullable Object o) {
        return this == o || o instanceof Annotation && this.equalTo((Annotation)o);
    }

    private boolean equalTo(Annotation other) {
        return this.id.equals(other.id) && this.annotationType == other.annotationType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.annotationType});
    }

    private static Annotation parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "annotation");
        String id = ParserSupport.getAttr(map, "id", String.class).orElse("");
        AnnotationType annotationType = AnnotationType.PARSER.parse((String)ParserSupport.getAttrOrThrow(map, "annotationType"));
        return Annotation.annotation(id, annotationType);
    }

    public static enum AnnotationType {
        INLINE_COMMENT("inlineComment");

        static final EnumParser<AnnotationType> PARSER;
        private final String annotationType;

        private AnnotationType(String annotationType) {
            this.annotationType = annotationType;
        }

        public String annotationType() {
            return this.annotationType;
        }

        static {
            PARSER = new EnumParser<AnnotationType>(AnnotationType.class, AnnotationType::annotationType);
        }
    }
}

