/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.ex.node;

import com.atlassian.adf.model.ex.node.NodeException;

public class LayoutSectionException
extends NodeException {
    private static final long serialVersionUID = 1L;

    LayoutSectionException(String message) {
        super(message);
    }

    public static class TooManyLayoutColumns
    extends ColumnCountException {
        private static final long serialVersionUID = 1L;

        public TooManyLayoutColumns(int count) {
            super(count, "Too many layout columns provided: maximum=5; actual=" + count);
        }
    }

    public static class NotEnoughLayoutColumns
    extends ColumnCountException {
        private static final long serialVersionUID = 1L;

        public NotEnoughLayoutColumns(int count) {
            super(count, "Not enough layout columns provided: minimum=1; actual=" + count);
        }
    }

    public static abstract class ColumnCountException
    extends LayoutSectionException {
        private static final long serialVersionUID = 1L;
        private final int count;

        ColumnCountException(int count, String message) {
            super(message);
            this.count = count;
            if (count >= 1 && count <= 5) {
                throw new IllegalArgumentException("This should only be called with an invalid count: " + count);
            }
        }

        public int count() {
            return this.count;
        }
    }
}

