/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.util;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@ReturnValuesAreNonnullByDefault
@Internal
public abstract class Functions {
    private Functions() {
    }

    public static <T> Function<T, Void> voidFn(Consumer<T> effect) {
        return t -> {
            effect.accept(t);
            return null;
        };
    }

    public static <T, U> List<U> mapToList(T[] source, Function<? super T, ? extends U> mapper) {
        return Functions.mapToList(Arrays.stream(source), mapper);
    }

    public static <T, U> List<U> mapToList(Iterable<T> source, Function<? super T, ? extends U> mapper) {
        return Functions.mapToList(StreamSupport.stream(source.spliterator(), false), mapper);
    }

    public static <T, U> List<U> mapToList(Stream<T> source, Function<? super T, ? extends U> mapper) {
        return source.map(mapper).collect(Collectors.toUnmodifiableList());
    }

    public static <T> boolean iterateJoined(Iterable<T> source, Consumer<? super T> effect, Runnable joiner) {
        Iterator<T> iter = source.iterator();
        if (!iter.hasNext()) {
            return false;
        }
        effect.accept(iter.next());
        while (iter.hasNext()) {
            joiner.run();
            effect.accept(iter.next());
        }
        return true;
    }
}

