/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.ex.mark.MarkException;
import com.atlassian.adf.model.mark.Mark;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.FieldMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

class MarkHolder<M extends Mark> {
    private static final Predicate<Object> ALWAYS_FALSE = mark -> false;
    private static final Map<?, ?> EMPTY_MAP = Collections.emptyMap();
    private Map<String, M> marks = (Map)Cast.unsafeCast(EMPTY_MAP);
    private Map<String, Predicate<? super M>> rules = (Map)Cast.unsafeCast(EMPTY_MAP);
    private final int limit;

    private MarkHolder(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit cannot be negative: " + limit);
        }
        this.limit = limit;
    }

    static <M extends Mark> MarkHolder<M> unlimited() {
        return new MarkHolder<M>(Integer.MAX_VALUE);
    }

    static <M extends Mark> MarkHolder<M> limit(int limit) {
        return new MarkHolder<M>(limit);
    }

    void add(M mark) {
        AdfException.frame("." + mark.elementType(), () -> {
            Supplier err = this.addIfAllowed(mark).orElse(null);
            if (err != null) {
                throw (AdfException)err.get();
            }
            return null;
        });
    }

    Optional<Supplier<? extends MarkException.ConstraintViolation>> addIfAllowed(M mark) {
        if (this.size() >= this.limit) {
            return Optional.of(() -> new MarkException.LimitReached(this.limit, this.marks));
        }
        for (Map.Entry<String, Predicate<M>> entry : this.rules.entrySet()) {
            Predicate<M> rule = entry.getValue();
            if (rule.test(mark)) continue;
            String reason = entry.getKey();
            return Optional.of(() -> new MarkException.MarkDisallowed(reason, (Mark)mark));
        }
        Mark existing = (Mark)this.marksRW().putIfAbsent(mark.elementType(), mark);
        if (existing != null) {
            return Optional.of(() -> new MarkException.DuplicateMarkType((Mark)mark));
        }
        return Optional.empty();
    }

    Collection<M> get() {
        return Collections.unmodifiableCollection(this.marks.values());
    }

    Set<String> getTypes() {
        return Collections.unmodifiableSet(this.marks.keySet());
    }

    boolean containsType(String type) {
        return this.marks.containsKey(type);
    }

    boolean containsMark(M mark) {
        return mark.equals(this.marks.get(mark.elementType()));
    }

    Optional<M> get(String type) {
        return Optional.ofNullable((Mark)this.marks.get(type));
    }

    Optional<M> remove(String type) {
        return Optional.ofNullable((Mark)this.marks.remove(type));
    }

    boolean removeAll(Class<? extends M> markClass) {
        return this.marks.values().removeIf(markClass::isInstance);
    }

    boolean remove(M mark) {
        return this.marks.remove(mark.elementType(), mark);
    }

    <T extends M> Stream<T> stream(Class<T> markClass) {
        return this.marks.values().stream().filter(markClass::isInstance).map(markClass::cast);
    }

    private Map<String, Predicate<? super M>> rulesRW() {
        Map<String, Predicate<M>> rules = this.rules;
        if (rules == EMPTY_MAP) {
            rules = new LinkedHashMap<String, Predicate<? super M>>();
            this.rules = rules;
        }
        return rules;
    }

    private Map<String, M> marksRW() {
        Map<String, M> marks = this.marks;
        if (marks == EMPTY_MAP) {
            this.marks = marks = new LinkedHashMap<String, M>();
        }
        return marks;
    }

    void disable(String reason) {
        if (!this.marks.isEmpty()) {
            throw new MarkException.RestrictedMarkAlreadyPresent(reason, this.marks);
        }
        Map<String, Predicate<M>> rules = this.rulesRW();
        if (rules.put(reason, ALWAYS_FALSE) == null && rules.size() > 1) {
            rules.keySet().removeIf(key -> !key.equals(reason));
        }
    }

    void restrictToInstancesOf(Class<? extends Mark> cls, String reason) {
        this.addRule(cls::isInstance, reason);
    }

    void rejectInstancesOf(Class<? extends Mark> cls, String reason) {
        this.addRule(mark -> !cls.isInstance(mark), reason);
    }

    void addRule(Predicate<? super M> rule, String reason) {
        this.validateRule(reason, rule);
        this.rulesRW().put(reason, rule);
    }

    void validate() {
        this.rules.forEach(this::validateRule);
    }

    private void validateRule(String reason, Predicate<? super M> rule) {
        Map<String, M> marks = this.marks;
        for (Mark mark : marks.values()) {
            if (rule.test(mark)) continue;
            throw new MarkException.MarkDisallowed(reason, mark);
        }
    }

    List<Map<String, ?>> toListOfMaps() {
        if (this.marks.isEmpty()) {
            return Collections.emptyList();
        }
        return this.marks.values().stream().map(Element::toMap).collect(Collectors.toList());
    }

    void addToMap(FieldMap map) {
        if (!this.marks.isEmpty()) {
            map.put("marks", this.toListOfMaps());
        }
    }

    boolean isEmpty() {
        return this.marks.isEmpty();
    }

    int size() {
        return this.marks.size();
    }

    void clear() {
        this.marks = (Map)Cast.unsafeCast(EMPTY_MAP);
    }

    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof MarkHolder && ((MarkHolder)o).marks.equals(this.marks);
    }

    public int hashCode() {
        return this.marks.hashCode();
    }

    public String toString() {
        return "MarkHolder" + this.marks.values();
    }
}

