/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.ex;

import com.atlassian.adf.util.Cast;
import java.net.URISyntaxException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public abstract class AdfException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public static final String NODE_PREFIX = ".";
    public static final String MARK_PREFIX = ".";
    public static final String MARKS_PREFIX = ":marks";
    private final Deque<String> adfBacktrace = new LinkedList<String>();

    protected AdfException(String message) {
        super(message);
    }

    protected AdfException(String message, @Nullable Throwable cause) {
        super(message, cause);
    }

    public static <T> T frame(String frame, Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (AdfException e) {
            throw e.backtrace(frame);
        }
        catch (RuntimeException e) {
            throw new UnexpectedRuntimeException(e).backtrace(frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AdfException backtrace(String frame) {
        Deque<String> deque = this.adfBacktrace;
        synchronized (deque) {
            this.adfBacktrace.addFirst(Objects.requireNonNull(frame, "frame"));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getPath() {
        Deque<String> deque = this.adfBacktrace;
        synchronized (deque) {
            return this.adfBacktrace.isEmpty() ? null : String.join((CharSequence)"", this.adfBacktrace);
        }
    }

    @Override
    public String toString() {
        String path = this.getPath();
        if (path == null) {
            return super.toString();
        }
        return super.toString() + "  (path: " + path + ")";
    }

    public static class InvalidURI
    extends PropertyException {
        private static final long serialVersionUID = 1L;
        private final String uri;

        public InvalidURI(String propertyName, String uri) {
            super("Field or attribute '" + propertyName + "' must contain a valid URI", propertyName);
            this.uri = Objects.requireNonNull(uri, "uri");
        }

        public InvalidURI(String propertyName, String uri, @Nullable URISyntaxException cause) {
            super("Field or attribute '" + propertyName + "' must contain a valid URI", propertyName, cause);
            this.uri = Objects.requireNonNull(uri, "uri");
        }

        public String uri() {
            return this.uri;
        }
    }

    public static class UnsupportedEnumValue
    extends AdfException {
        private static final long serialVersionUID = 1L;
        private final String enumName;
        @Nullable
        private final String enumValue;

        public UnsupportedEnumValue(String enumName, @Nullable String enumValue) {
            super("Invalid value supplied for enum '" + enumName + "': " + Optional.ofNullable(enumValue).map(x -> "'" + x + "'").orElse("null"));
            this.enumName = enumName;
            this.enumValue = enumValue;
        }

        public String enumName() {
            return this.enumName;
        }

        @Nullable
        public String enumValue() {
            return this.enumValue;
        }
    }

    public static class ValueTypeMismatch
    extends PropertyException {
        private static final long serialVersionUID = 1L;
        private final String expectedType;
        private final String actualType;

        public ValueTypeMismatch(String propertyName, String expectedType, String actualType) {
            super(propertyName, "Field or attribute '" + propertyName + "' was expected to have type '" + expectedType + "', but the actual value was of type '" + actualType + "'");
            this.expectedType = Objects.requireNonNull(expectedType, "expectedType");
            this.actualType = Objects.requireNonNull(actualType, "actualType");
        }

        public String expectedType() {
            return this.expectedType;
        }

        public String actualType() {
            return this.actualType;
        }
    }

    public static class DuplicateProperty
    extends PropertyException {
        private static final long serialVersionUID = 1L;

        public DuplicateProperty(String propertyName) {
            super(propertyName, "Duplicate field or attribute: '" + propertyName + "'");
        }
    }

    public static class EmptyProperty
    extends PropertyException {
        private static final long serialVersionUID = 1L;

        public EmptyProperty(String propertyName) {
            super(propertyName, "Field or attribute cannot be empty: '" + propertyName + "'");
        }
    }

    public static class MissingProperty
    extends PropertyException {
        private static final long serialVersionUID = 1L;

        public MissingProperty(String propertyName) {
            super(propertyName, "Required field or attribute is missing or in the wrong place: '" + propertyName + "'");
        }
    }

    public static abstract class PropertyException
    extends AdfException {
        private static final long serialVersionUID = 1L;
        private final String propertyName;

        PropertyException(String propertyName, String message) {
            super(message);
            this.propertyName = Objects.requireNonNull(propertyName, "propertyName");
        }

        PropertyException(String propertyName, String message, @Nullable Throwable cause) {
            super(message, cause);
            this.propertyName = Objects.requireNonNull(propertyName, "propertyName");
        }

        public String propertyName() {
            return this.propertyName;
        }
    }

    public static class MissingType
    extends AdfException {
        private static final long serialVersionUID = 1L;

        public MissingType() {
            super("A 'type' field with a non-empty string value is mandatory for all objects within an ADF document");
        }
    }

    public static class UnexpectedRuntimeException
    extends AdfException {
        private static final long serialVersionUID = 1L;

        public UnexpectedRuntimeException(RuntimeException cause) {
            super("Caught unexpected runtime exception: " + cause, Objects.requireNonNull(cause, "cause"));
        }

        @Override
        public RuntimeException getCause() {
            return (RuntimeException)Cast.unsafeCast(super.getCause());
        }
    }
}

