package com.atlassian.adf.util;

import com.atlassian.adf.model.node.Doc;
import com.atlassian.adf.model.node.Mention;
import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;

/**
 * From {@code src/lib/adf/adf-sanitizer.ts} in {@code pf-content-service}.
 */
@PublicApi
@ReturnValuesAreNonnullByDefault
public class Sanitizer {

    private Sanitizer() {}

    public static Doc sanitize(Doc doc) {
        Doc newDoc = doc.copy();
        newDoc.transformDescendants(Mention.class, Sanitizer::sanitizeMention);
        return newDoc;
    }

    private static Mention sanitizeMention(Mention mention) {
        return Mention.mention(mention.id()).accessLevel("");
    }
}
