package com.atlassian.adf.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;

import java.util.function.Consumer;
import java.util.function.Function;

import static com.atlassian.adf.util.Functions.voidFn;

/**
 * Sum type of two other types.
 */
@PublicApi
@ReturnValuesAreNonnullByDefault
public interface Fold2<A, B> {
    <T> T fold(
            Function<? super A, ? extends T> ifA,
            Function<? super B, ? extends T> ifB
    );

    default void accept(
            Consumer<? super A> ifA,
            Consumer<? super B> ifB
    ) {
        fold(voidFn(ifA), voidFn(ifB));
    }
}
