package com.atlassian.adf.util;

import com.atlassian.annotations.Internal;

import javax.annotation.Nullable;

/**
 * This is a way for us to declare explicitly that we know something that the compiler doesn't and pinky-swear
 * that the value we have really is of the inferred return type.
 * <p>
 * This utility method should really be available from the JDK itself, but in the meantime...
 */
@Internal
public class Cast {
    private Cast() {
        // static-only utility class
    }

    /**
     * Infer the expected type from the context and implicitly cast the provided value to match it.
     *
     * @param obj the object that we expect to be of the needed type
     * @param <T> the type required, as inferred by the compiler
     * @return {@code (T) obj}
     * @throws ClassCastException at runtime if the given object is not of the expected type
     */
    @SuppressWarnings("unchecked")
    public static <T> T unsafeCast(@Nullable Object obj) {
        return (T) obj;
    }
}
