/**
 * Basic description of what an ADF parser looks like.
 * Implementations need to select a transport format (such as a {@code String}) and implement the
 * translations to and from the {@link com.atlassian.adf.model.node.Doc} node from that format.
 * <p>
 * It will generally make sense for implementations to use {@link com.atlassian.adf.model.node.Doc#toMap()}
 * during marshalling and {@link com.atlassian.adf.model.node.Doc#parse(java.util.Map)} for
 * unmarshalling.
 */
@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@PublicApi
@ReturnValuesAreNonnullByDefault
package com.atlassian.adf.parser;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.nullability.FieldsAreNonnullByDefault;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;

import javax.annotation.ParametersAreNonnullByDefault;