package com.atlassian.adf.parser;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.PublicSpi;

import java.util.Map;

/**
 * Very simplified view of a JSON parser that only provides conversion to/from <code>Map&lt;String></code>.
 * The content is not validated beyond confirming that it is well-formed JSON; no rules concerning the ADF
 * schema are validated at this level.
 */
@PublicApi
@PublicSpi
public interface JsonParser {
    String toJson(Map<String, ?> map);

    Map<String, ?> fromJson(String json);
}
