/**
 * Special nodes that wrap opaque content nodes that have an unrecognized type.
 * <p>
 * For example, if while processing list items a node of type {@code "foo"} is encountered,
 * then a {@link com.atlassian.adf.model.node.unsupported.UnsupportedListItemContent unsupported list item}
 * node is substituted for it. This helps preserve that content if the document structure is changed, but
 * in most other ways it is not possible to interact with these unsupported node types.
 */
@FieldsAreNonnullByDefault
@Internal
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
package com.atlassian.adf.model.node.unsupported;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.nullability.FieldsAreNonnullByDefault;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;

import javax.annotation.ParametersAreNonnullByDefault;
