package com.atlassian.adf.model.node.unsupported;

import com.atlassian.adf.model.ex.node.NodeException;
import com.atlassian.adf.model.node.Node;
import com.atlassian.adf.util.Factory;

import javax.annotation.Nullable;
import java.util.Map;

import static com.atlassian.adf.util.Cast.unsafeCast;
import static com.atlassian.adf.util.Factory.extractLookupMap;
import static com.atlassian.adf.util.ParserSupport.getTypeOrThrow;

public class UnsupportedNodeFactory {
    private static final Map<Class<? extends Node>, Factory<? extends Node>> UNSUPPORTED_MAP = extractLookupMap(
            Factory::typeClass,
            UnsupportedCaptionContent.FACTORY,
            UnsupportedDocContent.FACTORY,
            UnsupportedInlineContent.FACTORY,
            UnsupportedListItemContent.FACTORY,
            UnsupportedNestedExpandContent.FACTORY,
            UnsupportedNonNestableBlockContent.FACTORY,
            UnsupportedPanelContent.FACTORY,
            UnsupportedTableCellContent.FACTORY
    );

    public static <N extends Node> N unsupportedNode(
            String parentType,
            Class<N> requiredClass,
            Map<String, ?> map
    ) {
        Factory<?> factory = UNSUPPORTED_MAP.get(requiredClass);
        if (factory != null) {
            return unsafeCast(factory.parse(map));
        }

        // There's unsupported, and then there is Really Unsupported. If we are in a context where we
        // expect new types of some marker interface to get introduced, then we do have some limited
        // ability to work around that by using a placeholder for unsupported nodes of that type. These
        // are very limited in the modifications that they allow, but they will at least preserve their
        // content as-is. However, in cases where a more concrete type was expected (like a "text"), we
        // have to fail instead.
        throw new NodeException.TypeMismatch(parentType, requiredClass, getTypeOrThrow(map));

    }
}
