/**
 * Marker interfaces and other supporting types that help classify nodes by how they may be used.
 * The usual pattern here is to name the marker interface as <code><em>NodeType</em>Content</code>
 * when there is a single type of content node that governs this definition, such as {@code ListItemContent}
 * for anything that may be used within {@code ListItem} nodes.
 * <p>
 * Some node types, like {@link com.atlassian.adf.model.node.type.InlineContent InlineContent}, apply
 * to more than one kind of content node. In this case, {@code Heading} and {@code Paragraph} nodes both
 * accept inline nodes. When there is no single owner, the name is generally take from (or at least
 * inspired by) whatever name is used in the JSON schema.
 */
@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@PublicApi
@ReturnValuesAreNonnullByDefault
package com.atlassian.adf.model.node.type;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.nullability.FieldsAreNonnullByDefault;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;

import javax.annotation.ParametersAreNonnullByDefault;