package com.atlassian.adf.model.node.type;

import com.atlassian.adf.model.node.ListItem;
import com.atlassian.adf.model.node.Node;

import java.util.stream.Stream;

import static com.atlassian.adf.model.node.ListItem.listItem;

/**
 * Describes features that are common to {@code bulletList} and {@code taskList} nodes.
 */
public interface ListNode<L extends ListNode<L>>
        extends ContentNode<L, ListItem> {

    /**
     * A convenience method for
     * <code>
     * {@link ContentNode#content(Node) content}({@link ListItem#listItem(String) listItem}(content))
     * </code>
     *
     * @param content the content to add as a single list item within the list
     * @return {@code this}
     */
    default L li(String content) {
        return content(listItem(content));
    }

    /**
     * A convenience method for
     * <code>
     * {@link ContentNode#content(Node) content}({@link ListItem#listItem(String[]) listItem}(content))
     * </code>
     *
     * @param content the content to add as a single list item within the list
     * @return {@code this}
     */
    default L li(String... content) {
        return content(listItem(content));
    }

    /**
     * A convenience method for
     * <code>
     * {@link ContentNode#content(Node) content}({@link ListItem#listItem(ListItemContent) listItem}(content))
     * </code>
     *
     * @param content the content to add as a single list item within the list
     * @return {@code this}
     */
    default L li(ListItemContent content) {
        return content(listItem(content));
    }

    /**
     * A convenience method for
     * <code>
     * {@link ContentNode#content(Node) content}({@link ListItem#listItem(ListItemContent[]) listItem}(content))
     * </code>
     *
     * @param content the content to add as a single list item within the list
     * @return {@code this}
     */
    default L li(ListItemContent... content) {
        return content(listItem(content));
    }

    /**
     * A convenience method for
     * <code>
     * {@link ContentNode#content(Node) content}({@link ListItem#listItem(Iterable) listItem}(content))
     * </code>
     *
     * @param content the content to add as a single list item within the list
     * @return {@code this}
     */
    default L li(Iterable<? extends ListItemContent> content) {
        return content(listItem(content));
    }

    /**
     * A convenience method for
     * <code>
     * {@link ContentNode#content(Node) content}({@link ListItem#listItem(Stream) listItem}(content))
     * </code>
     *
     * @param content the content to add as a single list item within the list
     * @return {@code this}
     */
    default L li(Stream<? extends ListItemContent> content) {
        return content(listItem(content));
    }

}
