package com.atlassian.adf.model.node.type;

import com.atlassian.adf.model.mark.Mark;
import com.atlassian.adf.model.node.Node;

import javax.annotation.Nullable;
import java.util.Map;
import java.util.Optional;

/**
 * Describes features that are common to the various extension node types.
 */
public interface ExtensionNode<N extends ExtensionNode<N, M>, M extends Mark>
        extends Marked<N, M>, Node {

    @Override
    N copy();

    /**
     * @return the extension's key
     */
    String extensionKey();

    /**
     * Replace the extension's key.
     *
     * @param extensionKey the new extension key value; must not be empty
     * @return {@code this}
     */
    N extensionKey(String extensionKey);

    /**
     * @return the extension's type
     */
    String extensionType();

    /**
     * Replace the extension's type.
     *
     * @param extensionType the new extension type value; must not be empty
     * @return {@code this}
     */
    N extensionType(String extensionType);

    /**
     * @return the extension's local ID, or {@code empty} if it has not been set
     */
    Optional<String> localId();

    /**
     * Replaces (or clears) the extension's local ID.
     *
     * @param localId the extension's new local ID, or {@code null} to clear it.
     * @return {@code this}
     */
    N localId(@Nullable String localId);

    /**
     * @return the extension's text value, or {@code empty} if it has not been set
     */
    Optional<String> text();

    /**
     * Replaces (or clears) the extension's text value.
     *
     * @param text the extension's new text value, or {@code null} to clear it.
     * @return {@code this}
     */
    N text(@Nullable String text);

    /**
     * @return the extension's parameter map, or {@code empty} if it has not been set
     */
    Optional<Map<String, ?>> parameters();

    /**
     * Replaces (or clears) the extension's parameter map.
     *
     * @param parameters the extension's new parameter map, or {@code null} to discard any existing one.
     * @return {@code this}
     */
    N parameters(@Nullable Map<String, ?> parameters);
}
