package com.atlassian.adf.model.node;

import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.ListItemContent;
import com.atlassian.adf.model.node.type.ListNode;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.PanelContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.annotations.Internal;

import java.util.stream.Stream;

import static com.atlassian.adf.model.node.ListItem.listItem;

/**
 * Common parent of the {@link BulletList bulletList} and {@link OrderedList orderedList} node types.
 *
 * @param <L> the actual list type
 */
@Internal
public abstract class AbstractListNode<L extends AbstractListNode<L>>
        extends AbstractContentNode<L, ListItem>
        implements ListNode<L>,
        DocContent, LayoutColumnContent, ListItemContent, NonNestableBlockContent, PanelContent, TableCellContent {

    AbstractListNode() {
    }

    /**
     * A convenience method for
     * <code>
     * {@link AbstractContentNode#content(Node) content}({@link ListItem#listItem(String) listItem}(content))
     * </code>
     *
     * @param content the content to add as a single list item within the list
     * @return {@code this}
     */
    public L li(String content) {
        return content(listItem(content));
    }

    /**
     * A convenience method for
     * <code>
     * {@link AbstractContentNode#content(Node) content}({@link ListItem#listItem(String[]) listItem}(content))
     * </code>
     *
     * @param content the content to add as a single list item within the list
     * @return {@code this}
     */
    public L li(String... content) {
        return content(listItem(content));
    }

    /**
     * A convenience method for
     * <code>
     * {@link AbstractContentNode#content(Node) content}({@link ListItem#listItem(ListItemContent) listItem}(content))
     * </code>
     *
     * @param content the content to add as a single list item within the list
     * @return {@code this}
     */
    public L li(ListItemContent content) {
        return content(listItem(content));
    }

    /**
     * A convenience method for
     * <code>
     * {@link AbstractContentNode#content(Node) content}({@link ListItem#listItem(ListItemContent[]) listItem}(content))
     * </code>
     *
     * @param content the content to add as a single list item within the list
     * @return {@code this}
     */
    public L li(ListItemContent... content) {
        return content(listItem(content));
    }

    /**
     * A convenience method for
     * <code>
     * {@link AbstractContentNode#content(Node) content}({@link ListItem#listItem(Iterable) listItem}(content))
     * </code>
     *
     * @param content the content to add as a single list item within the list
     * @return {@code this}
     */
    public L li(Iterable<? extends ListItemContent> content) {
        return content(listItem(content));
    }

    /**
     * A convenience method for
     * <code>
     * {@link AbstractContentNode#content(Node) content}({@link ListItem#listItem(Stream) listItem}(content))
     * </code>
     *
     * @param content the content to add as a single list item within the list
     * @return {@code this}
     */
    public L li(Stream<? extends ListItemContent> content) {
        return content(listItem(content));
    }

    @Override
    protected void contentNodeValidate() {
        requireNotEmpty();
    }
}
