package com.atlassian.adf.model.mark.unsupported;

import com.atlassian.adf.model.UnsupportedElement;
import com.atlassian.adf.model.mark.type.CodeTextMark;
import com.atlassian.adf.model.mark.type.FormattedTextMark;
import com.atlassian.adf.model.mark.type.TextMark;
import com.atlassian.adf.util.Factory;
import com.atlassian.annotations.Internal;

import javax.annotation.concurrent.Immutable;
import java.util.Map;

/**
 * Represents some unknown mark that was used on a {@code text} node.
 * <p>
 * It is assumed to be usable as either a {@link CodeTextMark code} or {@link FormattedTextMark formatted-text}
 * mark. It cannot be modified, but its state will be preserved if possible.
 */
@Immutable
@Internal
public class UnsupportedTextMark
        extends UnsupportedElement
        implements CodeTextMark, FormattedTextMark {

    public static final Factory<TextMark> FACTORY = Factory.unsupported(TextMark.class, UnsupportedTextMark::new);

    @Override
    public UnsupportedTextMark copy() {
        return this;
    }

    @Override
    public String toString() {
        return toMap().toString();
    }

    private UnsupportedTextMark(Map<String, ?> map) {
        super(map);
    }
}
