/**
 * Marker interfaces that help classify mark types by how they may be used.
 * <p>
 * The marks are generally classified by something humans can infer about how they may be used
 * rather than by anything explicit in the JSON schema, although the type names given in that
 * schema will inspire the names used here when that makes any sense at all.
 * <p>
 * For example, the schema does not declare any explicit grouping of the "code" and "formatting"
 * mark types, but it does explicitly define "text" node subtypes with those names where only
 * certain mark types are allowed. In this library, that is handled by using marker interfaces to
 * identify marks in those two sets and making {@code Text} aware of the need to ensure that its
 * marks don't include any pairs that are incompatible in this respect.
 */
@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@PublicApi
@ReturnValuesAreNonnullByDefault
package com.atlassian.adf.model.mark.type;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.nullability.FieldsAreNonnullByDefault;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;

import javax.annotation.ParametersAreNonnullByDefault;