package com.atlassian.adf.model.mark;

import com.atlassian.adf.util.FieldMap;

import java.util.Map;

import static com.atlassian.adf.util.FieldMap.map;

abstract class AbstractMark implements Mark {
    protected FieldMap mapWithType() {
        return map(Key.TYPE, elementType());
    }

    @Override
    public Map<String, ?> toMap() {
        return mapWithType();
    }

    @Override
    public String toString() {
        return elementType();
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public void validate() {
        // Marks generally do all their validation up front
    }
}
