package com.atlassian.adf.model.ex.node;

/**
 * Reports a problem with a {@code taskList} node.
 */
public abstract class TaskListException extends NodeException {
    private static final long serialVersionUID = 1L;

    TaskListException(String message) {
        super(message);
    }

    /**
     * Reports an attempt to nest a {@code taskList} as the first piece of content in a {@code taskITem}.
     * Task lists may be nested like this, but only after at least one non-list content item is specified first.
     */
    public static class CannotUseNestedTaskListAsFirstContentItem extends TaskListException {
        private static final long serialVersionUID = 1L;

        public CannotUseNestedTaskListAsFirstContentItem() {
            super("The first content item in a task list cannot be another task list");
        }
    }
}
