package com.atlassian.adf.model.ex.node;

/**
 * Reports a problem with a {@code bulletList}, {@code orderedList}, or {@code listItem} node.
 */
public abstract class ListException extends NodeException {
    private static final long serialVersionUID = 1L;

    ListException(String message) {
        super(message);
    }

    /**
     * Reports an attempt to nest a {@code bulletList} or {@code orderedList} as the first piece of
     * content in a {@code listItem}. Lists may be nested like this, but only after at least one non-list
     * content item is specified first.
     */
    public static class CannotUseNestedListAsFirstContentItem extends ListException {
        private static final long serialVersionUID = 1L;

        public CannotUseNestedListAsFirstContentItem() {
            super("The first content item in a list item cannot be another list");
        }
    }

    /**
     * Reports an attempt to create an {@code orderedList} with an {@code order} value that is negative.
     */
    public static class OrderMustNotBeNegative extends ListException {
        private static final long serialVersionUID = 1L;

        private final int order;

        public OrderMustNotBeNegative(int order) {
            super("The 'order' value must not be negative: " + order);
            this.order = order;
        }

        public int order() {
            return order;
        }
    }
}
